/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.repository.management.model.ApplicationType;
import io.gravitee.repository.management.model.NotificationReferenceType;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.ApplicationAlertsResource;
import io.gravitee.rest.api.management.rest.resource.ApplicationAnalyticsResource;
import io.gravitee.rest.api.management.rest.resource.ApplicationLogsResource;
import io.gravitee.rest.api.management.rest.resource.ApplicationMembersResource;
import io.gravitee.rest.api.management.rest.resource.ApplicationMetadataResource;
import io.gravitee.rest.api.management.rest.resource.ApplicationNotificationSettingsResource;
import io.gravitee.rest.api.management.rest.resource.ApplicationSubscribedResource;
import io.gravitee.rest.api.management.rest.resource.ApplicationSubscriptionsResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.ApplicationEntity;
import io.gravitee.rest.api.model.InlinePictureEntity;
import io.gravitee.rest.api.model.PictureEntity;
import io.gravitee.rest.api.model.UpdateApplicationEntity;
import io.gravitee.rest.api.model.UrlPictureEntity;
import io.gravitee.rest.api.model.application.ApplicationSettings;
import io.gravitee.rest.api.model.application.SimpleApplicationSettings;
import io.gravitee.rest.api.model.configuration.application.ApplicationTypeEntity;
import io.gravitee.rest.api.model.notification.NotifierEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.ApplicationService;
import io.gravitee.rest.api.service.NotifierService;
import io.gravitee.rest.api.service.configuration.application.ApplicationTypeService;
import io.gravitee.rest.api.service.exceptions.ApplicationNotFoundException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.ByteArrayOutputStream;
import java.net.URI;
import java.util.List;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;

@Api(tags={"Applications"})
public class ApplicationResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private ApplicationService applicationService;
    @Inject
    private NotifierService notifierService;
    @Inject
    private ApplicationTypeService applicationTypeService;
    @PathParam(value="application")
    @ApiParam(name="application", required=true)
    private String application;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get an application", notes="User must have the READ permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Application", response=ApplicationEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_DEFINITION, acls={RolePermissionAction.READ})})
    public ApplicationEntity getApplication() {
        return this.applicationService.findById(this.application);
    }

    @GET
    @Path(value="configuration")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get application type definition of an application", notes="User must have the READ permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="ApplicationType", response=ApplicationType.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_DEFINITION, acls={RolePermissionAction.READ})})
    public Response getApplicationType() {
        ApplicationEntity applicationEntity = this.applicationService.findById(this.application);
        ApplicationTypeEntity applicationType = this.applicationTypeService.getApplicationType(applicationEntity.getType());
        return Response.ok((Object)applicationType).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update an application", notes="User must have APPLICATION_DEFINITION[UPDATE] permission to update an application.")
    @ApiResponses(value={@ApiResponse(code=200, message="Updated application", response=ApplicationEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_DEFINITION, acls={RolePermissionAction.UPDATE})})
    public ApplicationEntity updateApplication(@Valid @NotNull(message="An application must be provided") @Valid @NotNull(message="An application must be provided") UpdateApplicationEntity updatedApplication) {
        if (updatedApplication.getSettings() == null || updatedApplication.getSettings().getoAuthClient() == null && updatedApplication.getSettings().getApp() == null) {
            ApplicationSettings settings = new ApplicationSettings();
            SimpleApplicationSettings simpleAppSettings = new SimpleApplicationSettings();
            simpleAppSettings.setType(updatedApplication.getType());
            simpleAppSettings.setClientId(updatedApplication.getClientId());
            updatedApplication.setSettings(settings);
        }
        return this.applicationService.update(this.application, updatedApplication);
    }

    @GET
    @Path(value="picture")
    @ApiOperation(value="Get the application's picture", notes="User must have the READ permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Application's picture"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_DEFINITION, acls={RolePermissionAction.READ})})
    public Response getApplicationPicture(@Context Request request) throws ApplicationNotFoundException {
        return this.getImageResponse(request, (PictureEntity)this.applicationService.getPicture(this.application));
    }

    @GET
    @Path(value="background")
    @ApiOperation(value="Get the application's background", notes="User must have the READ permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Application's background"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_DEFINITION, acls={RolePermissionAction.READ})})
    public Response getApplicationBackground(@Context Request request) throws ApplicationNotFoundException {
        return this.getImageResponse(request, (PictureEntity)this.applicationService.getBackground(this.application));
    }

    private Response getImageResponse(Request request, PictureEntity picture) {
        if (picture instanceof UrlPictureEntity) {
            return Response.temporaryRedirect((URI)URI.create(((UrlPictureEntity)picture).getUrl())).build();
        }
        InlinePictureEntity image = (InlinePictureEntity)picture;
        if (image == null || image.getContent() == null) {
            return Response.ok().build();
        }
        CacheControl cc = new CacheControl();
        cc.setNoTransform(true);
        cc.setMustRevalidate(false);
        cc.setNoCache(false);
        cc.setMaxAge(86400);
        EntityTag etag = new EntityTag(Integer.toString(new String(image.getContent()).hashCode()));
        Response.ResponseBuilder builder = request.evaluatePreconditions(etag);
        if (builder != null) {
            return builder.cacheControl(cc).build();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(image.getContent(), 0, image.getContent().length);
        return Response.ok((Object)baos).cacheControl(cc).tag(etag).type(image.getType()).build();
    }

    @POST
    @Path(value="/renew_secret")
    @Produces(value={"application/json"})
    @ApiOperation(value="Renew the client secret for an OAuth2 application", notes="User must have APPLICATION_DEFINITION[UPDATE] permission to update an application.")
    @ApiResponses(value={@ApiResponse(code=200, message="Updated application", response=ApplicationEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_DEFINITION, acls={RolePermissionAction.UPDATE})})
    public ApplicationEntity renewApplicationClientSecret() {
        return this.applicationService.renewClientSecret(this.application);
    }

    @DELETE
    @ApiOperation(value="Delete an application", notes="User must have the DELETE permission to use this service")
    @ApiResponses(value={@ApiResponse(code=204, message="Application successfully deleted"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_DEFINITION, acls={RolePermissionAction.DELETE})})
    public Response deleteApplication() {
        this.applicationService.archive(this.application);
        return Response.noContent().build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="notifiers")
    @ApiOperation(value="List available notifiers for application", notes="User must have the APPLICATION_NOTIFICATION[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="LList of notifiers", response=NotifierEntity.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_NOTIFICATION, acls={RolePermissionAction.READ})})
    public List<NotifierEntity> getApplicationNotifiers() {
        return this.notifierService.list(NotificationReferenceType.APPLICATION, this.application);
    }

    @Path(value="members")
    public ApplicationMembersResource getApplicationMembersResource() {
        return (ApplicationMembersResource)this.resourceContext.getResource(ApplicationMembersResource.class);
    }

    @Path(value="subscriptions")
    public ApplicationSubscriptionsResource getApplicationSubscriptionsResource() {
        return (ApplicationSubscriptionsResource)this.resourceContext.getResource(ApplicationSubscriptionsResource.class);
    }

    @Path(value="subscribed")
    public ApplicationSubscribedResource getApplicationSubscribedResource() {
        return (ApplicationSubscribedResource)this.resourceContext.getResource(ApplicationSubscribedResource.class);
    }

    @Path(value="analytics")
    public ApplicationAnalyticsResource getApplicationAnalyticsResource() {
        return (ApplicationAnalyticsResource)this.resourceContext.getResource(ApplicationAnalyticsResource.class);
    }

    @Path(value="logs")
    public ApplicationLogsResource getApplicationLogsResource() {
        return (ApplicationLogsResource)this.resourceContext.getResource(ApplicationLogsResource.class);
    }

    @Path(value="notificationsettings")
    public ApplicationNotificationSettingsResource getNotificationSettingsResource() {
        return (ApplicationNotificationSettingsResource)this.resourceContext.getResource(ApplicationNotificationSettingsResource.class);
    }

    @Path(value="alerts")
    public ApplicationAlertsResource getApplicationAlertsResource() {
        return (ApplicationAlertsResource)this.resourceContext.getResource(ApplicationAlertsResource.class);
    }

    @Path(value="metadata")
    public ApplicationMetadataResource getApplicationMetadataResource() {
        return (ApplicationMetadataResource)this.resourceContext.getResource(ApplicationMetadataResource.class);
    }
}

