/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.quality;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.quality.QualityRuleEntity;
import io.gravitee.rest.api.model.quality.UpdateQualityRuleEntity;
import io.gravitee.rest.api.service.QualityRuleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Api(tags={"Configuration"})
public class QualityRuleResource
extends AbstractResource {
    @Inject
    private QualityRuleService qualityRuleService;
    @PathParam(value="id")
    @ApiParam(name="id", required=true)
    private String id;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a quality rule", notes="User must have the MANAGEMENT_QUALITY_RULE[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Quality rule", response=QualityRuleEntity.class), @ApiResponse(code=404, message="Quality rule not found"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_QUALITY_RULE, acls={RolePermissionAction.READ})})
    public QualityRuleEntity getQualityRule() {
        return this.qualityRuleService.findById(this.id);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update a quality rule", notes="User must have the MANAGEMENT_QUALITY_RULE[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Quality rule successfully updated", response=QualityRuleEntity.class), @ApiResponse(code=404, message="Quality rule not found"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_QUALITY_RULE, acls={RolePermissionAction.UPDATE})})
    public QualityRuleEntity updateQualityRule(@Valid @NotNull UpdateQualityRuleEntity updateQualityRuleEntity) {
        updateQualityRuleEntity.setId(this.id);
        return this.qualityRuleService.update(updateQualityRuleEntity);
    }

    @DELETE
    @Consumes(value={"application/json"})
    @ApiOperation(value="Delete a quality rule", notes="User must have the MANAGEMENT_QUALITY_RULE[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=201, message="Quality rule successfully deleted"), @ApiResponse(code=404, message="Quality rule not found"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_QUALITY_RULE, acls={RolePermissionAction.DELETE})})
    public void deleteQualityRule() {
        this.qualityRuleService.delete(this.id);
    }
}

