/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.organization;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.organization.RoleUsersResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.UpdateRoleEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.exceptions.RoleNotFoundException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Optional;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;

@Api(tags={"Roles"})
public class RoleResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private RoleService roleService;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a role", notes="User must have the MANAGEMENT_ROLE[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="A role", response=RoleEntity.class), @ApiResponse(code=404, message="Role not found"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_ROLE, acls={RolePermissionAction.READ})})
    public RoleEntity getRole(@PathParam(value="scope") RoleScope scope, @PathParam(value="role") String role) {
        Optional optRole = this.roleService.findByScopeAndName(scope, role);
        if (optRole.isPresent()) {
            return (RoleEntity)optRole.get();
        }
        throw new RoleNotFoundException(scope.name() + "_" + role);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update a role", notes="User must have the MANAGEMENT_ROLE[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Role successfully updated", response=RoleEntity.class), @ApiResponse(code=404, message="Role not found"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_ROLE, acls={RolePermissionAction.UPDATE})})
    public RoleEntity updateRole(@PathParam(value="scope") RoleScope scope, @PathParam(value="role") String role, @Valid @NotNull UpdateRoleEntity entity) {
        return this.roleService.update(entity);
    }

    @DELETE
    @Consumes(value={"application/json"})
    @ApiOperation(value="Delete a role", notes="User must have the MANAGEMENT_ROLE[DELETE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=204, message="Role successfully deleted", response=RoleEntity.class), @ApiResponse(code=404, message="Role not found"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_ROLE, acls={RolePermissionAction.DELETE})})
    public void deleteRole(@PathParam(value="scope") RoleScope scope, @PathParam(value="role") String role) {
        this.roleService.findByScopeAndName(scope, role).ifPresent(roleToDelete -> this.roleService.delete(roleToDelete.getId()));
    }

    @Path(value="/users")
    public RoleUsersResource getRoleUsersResource() {
        return (RoleUsersResource)this.resourceContext.getResource(RoleUsersResource.class);
    }
}

