/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.organization;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.EnvironmentsResource;
import io.gravitee.rest.api.management.rest.resource.auth.OAuth2AuthenticationResource;
import io.gravitee.rest.api.management.rest.resource.organization.ConsoleResource;
import io.gravitee.rest.api.management.rest.resource.organization.ConsoleSettingsResource;
import io.gravitee.rest.api.management.rest.resource.organization.CurrentUserResource;
import io.gravitee.rest.api.management.rest.resource.organization.OrganizationConfigurationResource;
import io.gravitee.rest.api.management.rest.resource.organization.UsersResource;
import io.gravitee.rest.api.management.rest.resource.portal.SocialIdentityProvidersResource;
import io.gravitee.rest.api.management.rest.resource.search.SearchResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.UpdateOrganizationEntity;
import io.gravitee.rest.api.model.configuration.identity.IdentityProviderActivationEntity;
import io.gravitee.rest.api.model.configuration.identity.IdentityProviderActivationReferenceType;
import io.gravitee.rest.api.model.configuration.identity.IdentityProviderEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.OrganizationService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.configuration.identity.IdentityProviderActivationService;
import io.gravitee.rest.api.service.configuration.identity.IdentityProviderService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Api
public class OrganizationResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private OrganizationService organizationService;
    @Inject
    private IdentityProviderService identityProviderService;
    @Inject
    private IdentityProviderActivationService identityProviderActivationService;

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Create an Organization", tags={"Organization"})
    @ApiResponses(value={@ApiResponse(code=201, message="Organization successfully created"), @ApiResponse(code=500, message="Internal server error")})
    public Response createOrganization(@ApiParam(name="organizationEntity", required=true) @Valid @NotNull UpdateOrganizationEntity organizationEntity) {
        organizationEntity.setId(GraviteeContext.getCurrentOrganization());
        return Response.ok((Object)this.organizationService.createOrUpdate(organizationEntity)).build();
    }

    @DELETE
    @Consumes(value={"application/json"})
    @ApiOperation(value="Delete an Organization", tags={"Organization"})
    @ApiResponses(value={@ApiResponse(code=204, message="Organization successfully deleted"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteOrganization() {
        this.organizationService.delete(GraviteeContext.getCurrentOrganization());
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @GET
    @Path(value="/identities")
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_IDENTITY_PROVIDER_ACTIVATION, acls={RolePermissionAction.READ})})
    @ApiOperation(value="Get the list of identity provider activations for current organization", notes="User must have the ORGANIZATION_IDENTITY_PROVIDER_ACTIVATION[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="List identity provider activations for current organization", response=IdentityProviderActivationEntity.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error")})
    public Set<IdentityProviderActivationEntity> listIdentityProviderActivations() {
        return this.identityProviderActivationService.findAllByTarget(new IdentityProviderActivationService.ActivationTarget(GraviteeContext.getCurrentOrganization(), IdentityProviderActivationReferenceType.ORGANIZATION));
    }

    @PUT
    @Path(value="/identities")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_IDENTITY_PROVIDER_ACTIVATION, acls={RolePermissionAction.CREATE, RolePermissionAction.DELETE, RolePermissionAction.UPDATE})})
    @ApiOperation(value="Update available organization identities", tags={"Organization"})
    @ApiResponses(value={@ApiResponse(code=204, message="Organization successfully updated"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateOrganizationIdentities(Set<IdentityProviderActivationEntity> identityProviderActivations) {
        this.identityProviderActivationService.updateTargetIdp(new IdentityProviderActivationService.ActivationTarget(GraviteeContext.getCurrentOrganization(), IdentityProviderActivationReferenceType.ORGANIZATION), identityProviderActivations.stream().filter(ipa -> {
            IdentityProviderEntity idp = this.identityProviderService.findById(ipa.getIdentityProvider());
            return GraviteeContext.getCurrentOrganization().equals(idp.getOrganization());
        }).map(IdentityProviderActivationEntity::getIdentityProvider).collect(Collectors.toList()));
        return Response.noContent().build();
    }

    @Path(value="auth/oauth2/{identity}")
    public OAuth2AuthenticationResource getOAuth2AuthenticationResource() {
        return (OAuth2AuthenticationResource)this.resourceContext.getResource(OAuth2AuthenticationResource.class);
    }

    @Path(value="configuration")
    public OrganizationConfigurationResource getConfigurationResource() {
        return (OrganizationConfigurationResource)this.resourceContext.getResource(OrganizationConfigurationResource.class);
    }

    @Path(value="console")
    public ConsoleResource getConsoleResource() {
        return (ConsoleResource)this.resourceContext.getResource(ConsoleResource.class);
    }

    @Path(value="environments")
    public EnvironmentsResource getEnvironmentsResource() {
        return (EnvironmentsResource)this.resourceContext.getResource(EnvironmentsResource.class);
    }

    @Path(value="social-identities")
    public SocialIdentityProvidersResource getSocialIdentityProvidersResource() {
        return (SocialIdentityProvidersResource)this.resourceContext.getResource(SocialIdentityProvidersResource.class);
    }

    @Path(value="search")
    public SearchResource getSearchResource() {
        return (SearchResource)this.resourceContext.getResource(SearchResource.class);
    }

    @Path(value="settings")
    public ConsoleSettingsResource getConsoleSettingsResource() {
        return (ConsoleSettingsResource)this.resourceContext.getResource(ConsoleSettingsResource.class);
    }

    @Path(value="users")
    public UsersResource getUsersResource() {
        return (UsersResource)this.resourceContext.getResource(UsersResource.class);
    }

    @Path(value="user")
    public CurrentUserResource getCurrentUserResource() {
        return (CurrentUserResource)this.resourceContext.getResource(CurrentUserResource.class);
    }
}

