/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.organization;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.notification.NotificationTemplateEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.notification.NotificationTemplateService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Set;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Api(tags={"Notifications"})
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class NotificationTemplatesResource
extends AbstractResource {
    @Inject
    private NotificationTemplateService notificationTemplateService;

    @GET
    @ApiOperation(value="List all notification templates.", notes="User must have the NOTIFICATION_TEMPLATES[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Notifications templates", responseContainer="List", response=NotificationTemplateEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_NOTIFICATION_TEMPLATES, acls={RolePermissionAction.READ})})
    public Response getNotificationTemplates(@ApiParam(value="filter by notification scope") @QueryParam(value="scope") String scope, @ApiParam(value="filter by notification hook") @QueryParam(value="hook") String hook) {
        if (hook == null || scope == null) {
            Set all = this.notificationTemplateService.findAll();
            return Response.ok((Object)all).build();
        }
        Set allByHookAndScope = this.notificationTemplateService.findByHookAndScope(hook, scope);
        return Response.ok((Object)allByHookAndScope).build();
    }

    @POST
    @ApiOperation(value="Create a notification template", notes="User must have the NOTIFICATION_TEMPLATES[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Created notification template", response=NotificationTemplateEntity.class), @ApiResponse(code=400, message="There must not be any ID in the payload"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_NOTIFICATION_TEMPLATES, acls={RolePermissionAction.CREATE})})
    public Response createNotificationTemplate(@Valid NotificationTemplateEntity newNotificationTemplateEntity) {
        NotificationTemplateEntity createdNotificationTemplate = this.notificationTemplateService.create(newNotificationTemplateEntity);
        if (createdNotificationTemplate != null) {
            return Response.ok((Object)createdNotificationTemplate).build();
        }
        return Response.serverError().build();
    }

    @Path(value="{notificationTemplateId}")
    @GET
    @ApiOperation(value="Get a specific notification template.", notes="User must have the NOTIFICATION_TEMPLATES[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Notification template found", response=NotificationTemplateEntity.class), @ApiResponse(code=404, message="Notification template not found"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_NOTIFICATION_TEMPLATES, acls={RolePermissionAction.READ})})
    public Response getNotificationTemplate(@ApiParam(value="ID of the notification template") @PathParam(value="notificationTemplateId") String notificationTemplateId) {
        NotificationTemplateEntity notificationTemplateEntity = this.notificationTemplateService.findById(notificationTemplateId);
        return Response.ok((Object)notificationTemplateEntity).build();
    }

    @Path(value="{notificationTemplateId}")
    @PUT
    @ApiOperation(value="Update an existing notification template", notes="User must have the NOTIFICATION_TEMPLATES[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Updated notification template", response=NotificationTemplateEntity.class), @ApiResponse(code=400, message="ID in path parameter is not the same as in the payload"), @ApiResponse(code=404, message="Notification template not found"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_NOTIFICATION_TEMPLATES, acls={RolePermissionAction.UPDATE})})
    public Response updateNotificationTemplate(@ApiParam(value="ID of the notification template") @PathParam(value="notificationTemplateId") String notificationTemplateId, @Valid NotificationTemplateEntity notificationTemplateEntityUpdate) {
        if (!notificationTemplateEntityUpdate.getId().equals(notificationTemplateId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        NotificationTemplateEntity updatedNotificationTemplate = this.notificationTemplateService.update(notificationTemplateEntityUpdate);
        if (updatedNotificationTemplate != null) {
            return Response.ok((Object)updatedNotificationTemplate).build();
        }
        return Response.serverError().build();
    }
}

