/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.configuration.application.registration;

import io.gravitee.rest.api.management.rest.model.configuration.application.ClientRegistrationProviderListItem;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.configuration.application.registration.ClientRegistrationProviderResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.configuration.application.registration.ClientRegistrationProviderEntity;
import io.gravitee.rest.api.model.configuration.application.registration.InitialAccessTokenType;
import io.gravitee.rest.api.model.configuration.application.registration.NewClientRegistrationProviderEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.configuration.application.ClientRegistrationService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;

@Api(tags={"Client Registration Providers"})
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ClientRegistrationProvidersResource
extends AbstractResource {
    @Autowired
    private ClientRegistrationService clientRegistrationService;
    @Context
    private ResourceContext resourceContext;

    @GET
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_CLIENT_REGISTRATION_PROVIDER, acls={RolePermissionAction.READ})})
    @ApiOperation(value="Get the list of client registration providers", notes="User must have the PORTAL_CLIENT_REGISTRATION_PROVIDER[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="List client registration providers", response=ClientRegistrationProviderListItem.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error")})
    public List<ClientRegistrationProviderListItem> getClientRegistrationProviders() {
        return this.clientRegistrationService.findAll().stream().map(clientRegistrationProvider -> {
            ClientRegistrationProviderListItem item = new ClientRegistrationProviderListItem();
            item.setId(clientRegistrationProvider.getId());
            item.setName(clientRegistrationProvider.getName());
            item.setDescription(clientRegistrationProvider.getDescription());
            item.setCreatedAt(clientRegistrationProvider.getCreatedAt());
            item.setUpdatedAt(clientRegistrationProvider.getUpdatedAt());
            return item;
        }).collect(Collectors.toList());
    }

    @POST
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_CLIENT_REGISTRATION_PROVIDER, acls={RolePermissionAction.CREATE})})
    @ApiOperation(value="Create a client registration provider", notes="User must have the PORTAL_CLIENT_REGISTRATION_PROVIDER[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=201, message="Client registration provider provider successfully created", response=ClientRegistrationProviderEntity.class), @ApiResponse(code=500, message="Internal server error")})
    public Response createClientRegistrationProvider(@ApiParam(name="identity-provider", required=true) @Valid @NotNull NewClientRegistrationProviderEntity newClientRegistrationProviderEntity) {
        ClientRegistrationProviderEntity newClientRegistrationProvider;
        if (newClientRegistrationProviderEntity.getInitialAccessTokenType() == InitialAccessTokenType.CLIENT_CREDENTIALS) {
            if (newClientRegistrationProviderEntity.getClientId() == null || newClientRegistrationProviderEntity.getClientSecret() == null) {
                throw new IllegalArgumentException("Client credentials are missing");
            }
        } else if (newClientRegistrationProviderEntity.getInitialAccessToken() == null) {
            throw new IllegalArgumentException("Access token is missing");
        }
        if ((newClientRegistrationProvider = this.clientRegistrationService.create(newClientRegistrationProviderEntity)) != null) {
            return Response.created((URI)this.getLocationHeader(newClientRegistrationProvider.getId())).entity((Object)newClientRegistrationProvider).build();
        }
        return Response.serverError().build();
    }

    @Path(value="{clientRegistrationProvider}")
    public ClientRegistrationProviderResource getClientRegistrationProviderResource() {
        return (ClientRegistrationProviderResource)this.resourceContext.getResource(ClientRegistrationProviderResource.class);
    }
}

