/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.auth;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.common.util.Maps;
import io.gravitee.rest.api.idp.api.authentication.UserDetails;
import io.gravitee.rest.api.management.rest.model.TokenEntity;
import io.gravitee.rest.api.management.rest.model.TokenType;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.security.cookies.CookieGenerator;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotBlank;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

abstract class AbstractAuthenticationResource {
    public static final String CLIENT_ID_KEY = "client_id";
    public static final String REDIRECT_URI_KEY = "redirect_uri";
    public static final String CLIENT_SECRET = "client_secret";
    public static final String CODE_KEY = "code";
    public static final String GRANT_TYPE_KEY = "grant_type";
    public static final String AUTH_CODE = "authorization_code";
    public static final String TOKEN = "token";
    public static final String STATE = "state";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    @Autowired
    protected Environment environment;
    @Autowired
    protected UserService userService;
    @Autowired
    protected MembershipService membershipService;
    @Autowired
    protected CookieGenerator cookieGenerator;

    AbstractAuthenticationResource() {
    }

    protected Map<String, Object> getResponseEntity(Response response) throws IOException {
        return this.getEntity(this.getResponseEntityAsString(response));
    }

    protected String getResponseEntityAsString(Response response) throws IOException {
        return (String)response.readEntity(String.class);
    }

    protected Map<String, Object> getEntity(String response) throws IOException {
        return (Map)MAPPER.readValue(response, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    protected Response connectUser(String userId, String state, HttpServletResponse servletResponse, String accessToken, String idToken) {
        UserEntity user = this.userService.connect(userId);
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        UserDetails userDetails = (UserDetails)authentication.getPrincipal();
        List authorities = userDetails.getAuthorities().stream().map(authority -> Maps.builder().put((Object)"authority", (Object)authority.getAuthority()).build()).collect(Collectors.toList());
        Set userRoles = this.membershipService.getRoles(MembershipReferenceType.ORGANIZATION, GraviteeContext.getCurrentOrganization(), MembershipMemberType.USER, userDetails.getId());
        if (!userRoles.isEmpty()) {
            userRoles.forEach(role -> authorities.add(Maps.builder().put((Object)"authority", (Object)(role.getScope().toString() + ':' + role.getName())).build()));
        }
        Algorithm algorithm = Algorithm.HMAC256((String)this.environment.getProperty("jwt.secret"));
        Date issueAt = new Date();
        Instant expireAt = issueAt.toInstant().plus(Duration.ofSeconds(((Integer)this.environment.getProperty("jwt.expire-after", Integer.class, (Object)604800)).intValue()));
        String token = JWT.create().withIssuer(this.environment.getProperty("jwt.issuer", "gravitee-management-auth")).withIssuedAt(issueAt).withExpiresAt(Date.from(expireAt)).withSubject(user.getId()).withClaim("permissions", authorities).withClaim("email", user.getEmail()).withClaim("firstname", user.getFirstname()).withClaim("lastname", user.getLastname()).withJWTId(UUID.randomUUID().toString()).sign(algorithm);
        TokenEntity tokenEntity = new TokenEntity();
        tokenEntity.setType(TokenType.BEARER);
        tokenEntity.setToken(token);
        if (idToken != null) {
            tokenEntity.setAccessToken(accessToken);
            tokenEntity.setIdToken(idToken);
        }
        if (state != null && !state.isEmpty()) {
            tokenEntity.setState(state);
        }
        Cookie bearerCookie = this.cookieGenerator.generate("Auth-Graviteeio-APIM", "Bearer%20" + token);
        servletResponse.addCookie(bearerCookie);
        return Response.ok((Object)tokenEntity).build();
    }

    public static class Payload {
        @NotBlank
        String clientId;
        @NotBlank
        String redirectUri;
        @NotBlank
        String code;
        String state;

        public String getClientId() {
            return this.clientId;
        }

        public String getRedirectUri() {
            return this.redirectUri;
        }

        public String getCode() {
            return this.code;
        }

        public String getState() {
            return this.state;
        }
    }
}

