/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.MonitoringResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.InstanceEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.InstanceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;

@Api(tags={"Gateway"})
public class InstanceResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private InstanceService instanceService;
    @PathParam(value="instance")
    private String instance;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a gateway instance")
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_INSTANCE, acls={RolePermissionAction.READ})})
    public InstanceEntity getInstance() {
        return this.instanceService.findByEvent(this.instance);
    }

    @Path(value="monitoring/{gatewayId}")
    public MonitoringResource getMonitoringResource() {
        return (MonitoringResource)this.resourceContext.getResource(MonitoringResource.class);
    }
}

