/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractCategoryResource;
import io.gravitee.rest.api.management.rest.resource.CategoryResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.CategoryEntity;
import io.gravitee.rest.api.model.NewCategoryEntity;
import io.gravitee.rest.api.model.UpdateCategoryEntity;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.CategoryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;

@Api(tags={"Categories"})
public class CategoriesResource
extends AbstractCategoryResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private CategoryService categoryService;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve list of categories")
    public List<CategoryEntity> getCategories() {
        Set apis = this.isAdmin() ? this.apiService.findAll() : (this.isAuthenticated() ? this.apiService.findByUser(this.getAuthenticatedUser(), null, true) : this.apiService.findByVisibility(Visibility.PUBLIC));
        boolean All = this.hasPermission(RolePermission.ENVIRONMENT_CATEGORY, RolePermissionAction.UPDATE, RolePermissionAction.CREATE, RolePermissionAction.DELETE);
        return this.categoryService.findAll().stream().filter(c -> All || !c.isHidden()).sorted(Comparator.comparingInt(CategoryEntity::getOrder)).map(c -> this.setPictures((CategoryEntity)c, true)).map(c -> {
            c.setTotalApis(this.categoryService.getTotalApisByCategory(apis, c));
            return c;
        }).collect(Collectors.toList());
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a category", notes="User must have the PORTAL_CATEGORY[CREATE] permission to use this service")
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_CATEGORY, acls={RolePermissionAction.CREATE})})
    public CategoryEntity createCategory(@Valid @NotNull NewCategoryEntity category) {
        return this.categoryService.create(category);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update an existing category", notes="User must have the PORTAL_CATEGORY[UPDATE] permission to use this service")
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_CATEGORY, acls={RolePermissionAction.UPDATE})})
    public List<CategoryEntity> updateCategories(@Valid @NotNull List<UpdateCategoryEntity> categories) {
        return this.categoryService.update(categories);
    }

    @Path(value="{categoryId}")
    public CategoryResource getCategoryResource() {
        return (CategoryResource)this.resourceContext.getResource(CategoryResource.class);
    }
}

