/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.model.ApplicationMembership;
import io.gravitee.rest.api.management.rest.model.TransferOwnership;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.ApplicationEntity;
import io.gravitee.rest.api.model.MemberEntity;
import io.gravitee.rest.api.model.MembershipListItem;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.permissions.ApplicationPermission;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.model.permissions.SystemRole;
import io.gravitee.rest.api.service.ApplicationService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.exceptions.SinglePrimaryOwnerException;
import io.gravitee.rest.api.service.exceptions.UserNotFoundException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Api(tags={"Application Memberships"})
public class ApplicationMembersResource
extends AbstractResource {
    @Inject
    private MembershipService membershipService;
    @Inject
    private ApplicationService applicationService;
    @Inject
    private UserService userService;
    @PathParam(value="application")
    @ApiParam(name="application", hidden=true)
    private String application;

    @GET
    @Path(value="/permissions")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get application members", notes="User must have the APPLICATION_MEMBER permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Application member's permissions", response=MemberEntity.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error")})
    public Response getApplicationMemberPermissions() {
        Map<String, char[]> permissions = new HashMap();
        if (this.isAuthenticated()) {
            String username = this.getAuthenticatedUser();
            ApplicationEntity applicationEntity = this.applicationService.findById(this.application);
            if (this.isAdmin()) {
                char[] rights = new char[]{RolePermissionAction.CREATE.getId(), RolePermissionAction.READ.getId(), RolePermissionAction.UPDATE.getId(), RolePermissionAction.DELETE.getId()};
                for (ApplicationPermission perm : ApplicationPermission.values()) {
                    permissions.put(perm.getName(), rights);
                }
            } else {
                permissions = this.membershipService.getUserMemberPermissions(applicationEntity, username);
            }
        }
        return Response.ok(permissions).build();
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="List application members", notes="User must have the READ permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Application successfully deleted", response=MembershipListItem.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_MEMBER, acls={RolePermissionAction.READ})})
    public List<MembershipListItem> getApplicationMembers() {
        this.applicationService.findById(this.application);
        return this.membershipService.getMembersByReference(MembershipReferenceType.APPLICATION, this.application).stream().map(MembershipListItem::new).sorted(Comparator.comparing(MembershipListItem::getId)).collect(Collectors.toList());
    }

    @POST
    @ApiOperation(value="Add or update an application member", notes="User must have the MANAGE_MEMBERS permission to use this service")
    @ApiResponses(value={@ApiResponse(code=201, message="Member has been added or updated successfully"), @ApiResponse(code=400, message="Membership parameter is not valid"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_MEMBER, acls={RolePermissionAction.CREATE}), @Permission(value=RolePermission.APPLICATION_MEMBER, acls={RolePermissionAction.UPDATE})})
    public Response addOrUpdateApplicationMember(@Valid @NotNull ApplicationMembership applicationMembership) {
        MemberEntity userMember;
        if (SystemRole.PRIMARY_OWNER.name().equals(applicationMembership.getRole())) {
            throw new SinglePrimaryOwnerException(RoleScope.APPLICATION);
        }
        this.applicationService.findById(this.application);
        MembershipService.MembershipReference reference = new MembershipService.MembershipReference(MembershipReferenceType.APPLICATION, this.application);
        MembershipService.MembershipMember member = new MembershipService.MembershipMember(applicationMembership.getId(), applicationMembership.getReference(), MembershipMemberType.USER);
        MembershipService.MembershipRole role = new MembershipService.MembershipRole(RoleScope.APPLICATION, applicationMembership.getRole());
        MemberEntity membership = null;
        if (applicationMembership.getId() != null && (userMember = this.membershipService.getUserMember(MembershipReferenceType.APPLICATION, this.application, applicationMembership.getId())) != null && userMember.getRoles() != null && !userMember.getRoles().isEmpty()) {
            membership = this.membershipService.updateRoleToMemberOnReference(reference, member, role);
        }
        if (membership == null) {
            this.membershipService.addRoleToMemberOnReference(reference, member, role);
        }
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @DELETE
    @ApiOperation(value="Remove an application member", notes="User must have the MANAGE_MEMBERS permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Member has been removed successfully"), @ApiResponse(code=400, message="User does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_MEMBER, acls={RolePermissionAction.DELETE})})
    public Response deleteApplicationMember(@ApiParam(name="user", required=true) @NotNull @QueryParam(value="user") String userId) {
        this.applicationService.findById(this.application);
        try {
            this.userService.findById(userId);
        }
        catch (UserNotFoundException unfe) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)unfe.getMessage()).build();
        }
        this.membershipService.deleteReferenceMember(MembershipReferenceType.APPLICATION, this.application, MembershipMemberType.USER, userId);
        return Response.ok().build();
    }

    @POST
    @Path(value="transfer_ownership")
    @ApiOperation(value="Transfer the ownership of the APPLICATION", notes="User must have the TRANSFER_OWNERSHIP permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Ownership has been transferred successfully"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_MEMBER, acls={RolePermissionAction.UPDATE})})
    public Response transferApplicationOwnership(@Valid @NotNull TransferOwnership transferOwnership) {
        ArrayList<RoleEntity> newRoles = new ArrayList<RoleEntity>();
        Optional optNewPORole = this.roleService.findByScopeAndName(RoleScope.APPLICATION, transferOwnership.getPoRole());
        if (optNewPORole.isPresent()) {
            newRoles.add((RoleEntity)optNewPORole.get());
        }
        this.applicationService.findById(this.application);
        this.membershipService.transferApplicationOwnership(this.application, new MembershipService.MembershipMember(transferOwnership.getId(), transferOwnership.getReference(), MembershipMemberType.USER), newRoles);
        return Response.ok().build();
    }
}

