/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.alert.AlertReferenceType;
import io.gravitee.rest.api.model.alert.AlertStatusEntity;
import io.gravitee.rest.api.model.alert.AlertTriggerEntity;
import io.gravitee.rest.api.model.alert.NewAlertTriggerEntity;
import io.gravitee.rest.api.model.alert.UpdateAlertTriggerEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.AlertService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Api(tags={"Application Alerts"})
public class ApplicationAlertsResource
extends AbstractResource {
    @Inject
    private AlertService alertService;
    @PathParam(value="application")
    @ApiParam(name="application", hidden=true)
    private String application;

    @GET
    @ApiOperation(value="List configured alerts of an application", notes="User must have the APPLICATION_ALERT[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="List of alerts", response=AlertTriggerEntity.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error")})
    @Produces(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_ALERT, acls={RolePermissionAction.READ})})
    public List<AlertTriggerEntity> getApplicationAlerts() {
        return this.alertService.findByReference(AlertReferenceType.APPLICATION, this.application);
    }

    @GET
    @Path(value="status")
    @ApiOperation(value="Get alerting status", notes="User must have the MANAGEMENT_ALERT[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Alerting status", response=AlertStatusEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Produces(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_ALERT, acls={RolePermissionAction.READ})})
    public AlertStatusEntity getApplicationAlertsStatus() {
        return this.alertService.getStatus();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create an alert for an application", notes="User must have the APPLICATION_ALERT[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Alert successfully created", response=AlertTriggerEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_ALERT, acls={RolePermissionAction.CREATE})})
    public AlertTriggerEntity createApplicationAlert(@Valid @NotNull NewAlertTriggerEntity alertEntity) {
        alertEntity.setReferenceType(AlertReferenceType.APPLICATION);
        alertEntity.setReferenceId(this.application);
        return this.alertService.create(alertEntity);
    }

    @Path(value="{alert}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update an alert for an application", notes="User must have the APPLICATION_ALERT[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Alert successfully updated", response=AlertTriggerEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_ALERT, acls={RolePermissionAction.UPDATE})})
    public AlertTriggerEntity updateApplicationAlert(@PathParam(value="alert") String alert, @Valid @NotNull UpdateAlertTriggerEntity alertEntity) {
        alertEntity.setId(alert);
        alertEntity.setReferenceType(AlertReferenceType.APPLICATION);
        alertEntity.setReferenceId(this.application);
        return this.alertService.update(alertEntity);
    }

    @Path(value="{alert}")
    @DELETE
    @Consumes(value={"application/json"})
    @ApiOperation(value="Delete an alert for an application", notes="User must have the APPLICATION_ALERT[DELETE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=204, message="Alert successfully deleted", response=AlertTriggerEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_ALERT, acls={RolePermissionAction.DELETE})})
    public void deleteApplicationAlert(@PathParam(value="alert") String alert) {
        this.alertService.delete(alert, this.application);
    }
}

