/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.Proxy;
import io.gravitee.definition.model.VirtualHost;
import io.gravitee.repository.management.model.NotificationReferenceType;
import io.gravitee.rest.api.exception.InvalidImageException;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.ApiAlertsResource;
import io.gravitee.rest.api.management.rest.resource.ApiAnalyticsResource;
import io.gravitee.rest.api.management.rest.resource.ApiAuditResource;
import io.gravitee.rest.api.management.rest.resource.ApiEventsResource;
import io.gravitee.rest.api.management.rest.resource.ApiHealthResource;
import io.gravitee.rest.api.management.rest.resource.ApiKeysResource;
import io.gravitee.rest.api.management.rest.resource.ApiLogsResource;
import io.gravitee.rest.api.management.rest.resource.ApiMembersResource;
import io.gravitee.rest.api.management.rest.resource.ApiMetadataResource;
import io.gravitee.rest.api.management.rest.resource.ApiNotificationSettingsResource;
import io.gravitee.rest.api.management.rest.resource.ApiPagesResource;
import io.gravitee.rest.api.management.rest.resource.ApiPlansResource;
import io.gravitee.rest.api.management.rest.resource.ApiQualityRulesResource;
import io.gravitee.rest.api.management.rest.resource.ApiRatingResource;
import io.gravitee.rest.api.management.rest.resource.ApiSubscribersResource;
import io.gravitee.rest.api.management.rest.resource.ApiSubscriptionsResource;
import io.gravitee.rest.api.management.rest.resource.param.LifecycleActionParam;
import io.gravitee.rest.api.management.rest.resource.param.ReviewActionParam;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.ApiQualityMetricsEntity;
import io.gravitee.rest.api.model.ApiStateEntity;
import io.gravitee.rest.api.model.EventType;
import io.gravitee.rest.api.model.ImportSwaggerDescriptorEntity;
import io.gravitee.rest.api.model.InlinePictureEntity;
import io.gravitee.rest.api.model.MessageEntity;
import io.gravitee.rest.api.model.ReviewEntity;
import io.gravitee.rest.api.model.WorkflowState;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.api.ApiLifecycleState;
import io.gravitee.rest.api.model.api.DuplicateApiEntity;
import io.gravitee.rest.api.model.api.SwaggerApiEntity;
import io.gravitee.rest.api.model.api.UpdateApiEntity;
import io.gravitee.rest.api.model.api.header.ApiHeaderEntity;
import io.gravitee.rest.api.model.notification.NotifierEntity;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.security.utils.ImageUtils;
import io.gravitee.rest.api.service.MessageService;
import io.gravitee.rest.api.service.NotifierService;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.QualityMetricsService;
import io.gravitee.rest.api.service.SwaggerService;
import io.gravitee.rest.api.service.exceptions.ApiNotFoundException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.ByteArrayOutputStream;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.jersey.message.internal.HttpHeaderReader;
import org.glassfish.jersey.message.internal.MatchingEntityTag;

@Api(tags={"APIs"})
public class ApiResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private NotifierService notifierService;
    @Inject
    private QualityMetricsService qualityMetricsService;
    @Inject
    private MessageService messageService;
    @Inject
    private ParameterService parameterService;
    @Inject
    private SwaggerService swaggerService;
    @PathParam(value="api")
    @ApiParam(name="api", required=true, value="The ID of the API")
    private String api;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the API", notes="User must have the READ permission on the API_DEFINITION to use this service on a private API.")
    @ApiResponses(value={@ApiResponse(code=200, message="API definition", response=ApiEntity.class), @ApiResponse(code=500, message="Internal server error")})
    public Response getApi() {
        ApiEntity apiEntity = this.apiService.findById(this.api);
        if (this.hasPermission(RolePermission.API_DEFINITION, this.api, RolePermissionAction.READ)) {
            this.setPictures(apiEntity);
        } else {
            this.filterSensitiveData(apiEntity);
        }
        return Response.ok((Object)apiEntity).tag(Long.toString(apiEntity.getUpdatedAt().getTime())).lastModified(apiEntity.getUpdatedAt()).build();
    }

    private void setPictures(ApiEntity apiEntity) {
        UriBuilder uriBuilder = this.uriInfo.getAbsolutePathBuilder().path("picture");
        uriBuilder.queryParam("hash", new Object[]{apiEntity.getUpdatedAt().getTime()});
        apiEntity.setPictureUrl(uriBuilder.build(new Object[0]).toString());
        apiEntity.setPicture(null);
        uriBuilder = this.uriInfo.getAbsolutePathBuilder().path("background");
        uriBuilder.queryParam("hash", new Object[]{apiEntity.getUpdatedAt().getTime()});
        apiEntity.setBackgroundUrl(uriBuilder.build(new Object[0]).toString());
        apiEntity.setBackground(null);
    }

    @GET
    @Path(value="picture")
    @ApiOperation(value="Get the API's picture", notes="User must have the READ permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="API's picture"), @ApiResponse(code=500, message="Internal server error")})
    public Response getApiPicture(@Context Request request) throws ApiNotFoundException {
        return this.getImageResponse(request, this.apiService.getPicture(this.api));
    }

    @GET
    @Path(value="background")
    @ApiOperation(value="Get the API's background", notes="User must have the READ permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="API's background"), @ApiResponse(code=500, message="Internal server error")})
    public Response getApiBackground(@Context Request request) throws ApiNotFoundException {
        return this.getImageResponse(request, this.apiService.getBackground(this.api));
    }

    private Response getImageResponse(Request request, InlinePictureEntity image) {
        this.canReadApi(this.api);
        CacheControl cc = new CacheControl();
        cc.setNoTransform(true);
        cc.setMustRevalidate(false);
        cc.setNoCache(false);
        cc.setMaxAge(86400);
        if (image == null || image.getContent() == null) {
            return Response.ok().cacheControl(cc).build();
        }
        EntityTag etag = new EntityTag(Integer.toString(new String(image.getContent()).hashCode()));
        Response.ResponseBuilder builder = request.evaluatePreconditions(etag);
        if (builder != null) {
            return builder.cacheControl(cc).build();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(image.getContent(), 0, image.getContent().length);
        return Response.ok((Object)baos).cacheControl(cc).tag(etag).type(image.getType()).build();
    }

    @POST
    @ApiOperation(value="Manage the API's lifecycle", notes="User must have the MANAGE_LIFECYCLE permission to use this service")
    @ApiResponses(value={@ApiResponse(code=204, message="API's picture"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DEFINITION, acls={RolePermissionAction.UPDATE})})
    public Response doApiLifecycleAction(@Context HttpHeaders headers, @ApiParam(required=true, allowableValues="START, STOP") @QueryParam(value="action") LifecycleActionParam action) {
        ApiEntity updatedApi;
        Response responseApi = this.getApi();
        Response.ResponseBuilder builder = this.evaluateIfMatch(headers, responseApi.getEntityTag().getValue());
        if (builder != null) {
            return builder.build();
        }
        ApiEntity apiEntity = (ApiEntity)responseApi.getEntity();
        switch (action.getAction()) {
            case START: {
                this.checkApiLifeCycle(apiEntity, action.getAction());
                updatedApi = this.apiService.start(apiEntity.getId(), this.getAuthenticatedUser());
                break;
            }
            case STOP: {
                this.checkApiLifeCycle(apiEntity, action.getAction());
                updatedApi = this.apiService.stop(apiEntity.getId(), this.getAuthenticatedUser());
                break;
            }
            default: {
                updatedApi = null;
            }
        }
        return Response.noContent().tag(Long.toString(updatedApi.getUpdatedAt().getTime())).lastModified(updatedApi.getUpdatedAt()).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update the API", notes="User must have the MANAGE_API permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="API successfully updated", response=ApiEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DEFINITION, acls={RolePermissionAction.UPDATE}), @Permission(value=RolePermission.API_GATEWAY_DEFINITION, acls={RolePermissionAction.UPDATE})})
    public Response updateApi(@Context HttpHeaders headers, @ApiParam(name="api", required=true) @Valid @NotNull UpdateApiEntity apiToUpdate) {
        Response responseApi = this.getApi();
        Response.ResponseBuilder builder = this.evaluateIfMatch(headers, responseApi.getEntityTag().getValue());
        if (builder != null) {
            return builder.build();
        }
        try {
            ImageUtils.verify((String)apiToUpdate.getPicture());
            ImageUtils.verify((String)apiToUpdate.getBackground());
        }
        catch (InvalidImageException e) {
            throw new BadRequestException("Invalid image format");
        }
        ApiEntity currentApi = (ApiEntity)responseApi.getEntity();
        if (!(this.hasPermission(RolePermission.API_GATEWAY_DEFINITION, this.api, RolePermissionAction.UPDATE) || Objects.equals(currentApi.getPrimaryOwner().getId(), this.getAuthenticatedUser()) || this.isAdmin())) {
            apiToUpdate.getProxy().setVirtualHosts(currentApi.getProxy().getVirtualHosts());
        }
        ApiEntity updatedApi = this.apiService.update(this.api, apiToUpdate, true);
        this.setPictures(updatedApi);
        return Response.ok((Object)updatedApi).tag(Long.toString(updatedApi.getUpdatedAt().getTime())).lastModified(updatedApi.getUpdatedAt()).build();
    }

    private Response.ResponseBuilder evaluateIfMatch(HttpHeaders headers, String etagValue) {
        String ifMatch = headers.getHeaderString("If-Match");
        if (ifMatch == null || ifMatch.isEmpty()) {
            return null;
        }
        ifMatch = ifMatch.replaceAll("-gzip", "");
        try {
            Set matchingTags = HttpHeaderReader.readMatchingEntityTag((String)ifMatch);
            MatchingEntityTag ifMatchHeader = (MatchingEntityTag)matchingTags.iterator().next();
            EntityTag eTag = new EntityTag(etagValue, ifMatchHeader.isWeak());
            return matchingTags != MatchingEntityTag.ANY_MATCH && !matchingTags.contains(eTag) ? Response.status((Response.Status)Response.Status.PRECONDITION_FAILED) : null;
        }
        catch (ParseException e) {
            return null;
        }
    }

    @DELETE
    @ApiOperation(value="Delete the API", notes="User must have the DELETE permission to use this service")
    @ApiResponses(value={@ApiResponse(code=204, message="API successfully deleted"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DEFINITION, acls={RolePermissionAction.DELETE})})
    public Response deleteApi() {
        this.apiService.delete(this.api);
        return Response.noContent().build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="deploy")
    @ApiOperation(value="Deploy API to gateway instances", notes="User must have the MANAGE_LIFECYCLE permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="API successfully deployed", response=ApiEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DEFINITION, acls={RolePermissionAction.UPDATE})})
    public Response deployApi() {
        try {
            ApiEntity apiEntity = this.apiService.deploy(this.api, this.getAuthenticatedUser(), EventType.PUBLISH_API);
            return Response.ok((Object)apiEntity).tag(Long.toString(apiEntity.getUpdatedAt().getTime())).lastModified(apiEntity.getUpdatedAt()).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("JsonProcessingException " + e)).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="state")
    @ApiOperation(value="Get the state of the API", notes="User must have the MANAGE_LIFECYCLE permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="API's state", response=ApiStateEntity.class), @ApiResponse(code=500, message="Internal server error")})
    public ApiStateEntity isApiSynchronized() {
        this.canReadApi(this.api);
        ApiStateEntity apiStateEntity = new ApiStateEntity();
        apiStateEntity.setApiId(this.api);
        this.setSynchronizationState(apiStateEntity);
        return apiStateEntity;
    }

    @POST
    @Consumes
    @Produces(value={"application/json"})
    @Path(value="rollback")
    @ApiOperation(value="Rollback API to a previous version", notes="User must have the MANAGE_LIFECYCLE permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="API successfully rollbacked", response=ApiEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DEFINITION, acls={RolePermissionAction.UPDATE})})
    public Response rollbackApi(@ApiParam(name="api", required=true) @Valid @NotNull UpdateApiEntity apiEntity) {
        try {
            ApiEntity rollbackedApi = this.apiService.rollback(this.api, apiEntity);
            return Response.ok((Object)rollbackedApi).tag(Long.toString(rollbackedApi.getUpdatedAt().getTime())).lastModified(rollbackedApi.getUpdatedAt()).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e).build();
        }
    }

    @POST
    @Deprecated
    @Produces(value={"application/json"})
    @Path(value="import")
    @ApiOperation(value="Update the API with an existing API definition", notes="User must have the MANAGE_API permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="API successfully updated from API definition", response=ApiEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DEFINITION, acls={RolePermissionAction.UPDATE})})
    public Response updateApiWithDefinition(@ApiParam(name="definition", required=true) String apiDefinition) {
        ApiEntity apiEntity = (ApiEntity)this.getApi().getEntity();
        ApiEntity updatedApi = this.apiService.createWithImportedDefinition(apiEntity, apiDefinition, this.getAuthenticatedUser());
        return Response.ok((Object)updatedApi).tag(Long.toString(updatedApi.getUpdatedAt().getTime())).lastModified(updatedApi.getUpdatedAt()).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="import")
    @ApiOperation(value="Update the API with an existing API definition", notes="User must have the MANAGE_API permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="API successfully updated from API definition", response=ApiEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DEFINITION, acls={RolePermissionAction.UPDATE})})
    public Response updateWithDefinitionPUT(@ApiParam(name="definition", required=true) String apiDefinition) {
        ApiEntity apiEntity = (ApiEntity)this.getApi().getEntity();
        ApiEntity updatedApi = this.apiService.updateWithImportedDefinition(apiEntity, apiDefinition, this.getAuthenticatedUser());
        return Response.ok((Object)updatedApi).tag(Long.toString(updatedApi.getUpdatedAt().getTime())).lastModified(updatedApi.getUpdatedAt()).build();
    }

    @POST
    @Deprecated
    @Path(value="import/swagger")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Deprecated, use PUT method instead. Update the API with an existing Swagger descriptor", notes="User must have the MANAGE_API permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="API successfully updated from Swagger descriptor", response=ApiEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DEFINITION, acls={RolePermissionAction.UPDATE})})
    public Response updateApiWithSwagger(@ApiParam(name="swagger", required=true) @Valid @NotNull ImportSwaggerDescriptorEntity swaggerDescriptor) {
        SwaggerApiEntity swaggerApiEntity = this.swaggerService.createAPI(swaggerDescriptor);
        ApiEntity updatedApi = this.apiService.updateFromSwagger(this.api, swaggerApiEntity, swaggerDescriptor);
        return Response.ok((Object)updatedApi).tag(Long.toString(updatedApi.getUpdatedAt().getTime())).lastModified(updatedApi.getUpdatedAt()).build();
    }

    @PUT
    @Path(value="import/swagger")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update the API with an existing Swagger descriptor", notes="User must have the MANAGE_API permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="API successfully updated from Swagger descriptor", response=ApiEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DEFINITION, acls={RolePermissionAction.UPDATE})})
    public Response updateApiWithSwaggerPUT(@ApiParam(name="swagger", required=true) @Valid @NotNull ImportSwaggerDescriptorEntity swaggerDescriptor, @QueryParam(value="definitionVersion") @DefaultValue(value="1.0.0") String definitionVersion) {
        SwaggerApiEntity swaggerApiEntity = this.swaggerService.createAPI(swaggerDescriptor, DefinitionVersion.valueOfLabel((String)definitionVersion));
        ApiEntity updatedApi = this.apiService.updateFromSwagger(this.api, swaggerApiEntity, swaggerDescriptor);
        return Response.ok((Object)updatedApi).tag(Long.toString(updatedApi.getUpdatedAt().getTime())).lastModified(updatedApi.getUpdatedAt()).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="export")
    @ApiOperation(value="Export the API definition in JSON format", notes="User must have the MANAGE_API permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="API definition", response=ApiEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DEFINITION, acls={RolePermissionAction.READ})})
    public Response exportApiDefinition(@QueryParam(value="version") @DefaultValue(value="default") String version, @QueryParam(value="exclude") @DefaultValue(value="") String exclude) {
        ApiEntity apiEntity = this.apiService.findById(this.api);
        String apiDefinition = this.apiService.exportAsJson(this.api, version, exclude.split(","));
        return Response.ok((Object)apiDefinition).header("Content-Disposition", (Object)String.format("attachment;filename=%s", this.getExportFilename(apiEntity))).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="notifiers")
    @ApiOperation(value="List available notifiers for API", notes="User must have the API_NOTIFICATION[READ] permission to use this service")
    @Permissions(value={@Permission(value=RolePermission.API_NOTIFICATION, acls={RolePermissionAction.READ})})
    public List<NotifierEntity> getApiNotifiers() {
        return this.notifierService.list(NotificationReferenceType.API, this.api);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="import-path-mappings")
    @ApiOperation(value="Import path mappings from a page", notes="User must have the MANAGE_API permission to use this service")
    @ApiResponses(value={@ApiResponse(code=201, message="Path mappings successfully imported", response=ApiEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DEFINITION, acls={RolePermissionAction.UPDATE})})
    public Response importApiPathMappingsFromPage(@QueryParam(value="page") @NotNull String page) {
        ApiEntity apiEntity = (ApiEntity)this.getApi().getEntity();
        ApiEntity updatedApi = this.apiService.importPathMappingsFromPage(apiEntity, page);
        return Response.ok((Object)updatedApi).tag(Long.toString(updatedApi.getUpdatedAt().getTime())).lastModified(updatedApi.getUpdatedAt()).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="quality")
    @ApiOperation(value="Get the quality metrics of the API")
    public ApiQualityMetricsEntity getApiQualityMetrics() {
        this.canReadApi(this.api);
        ApiEntity apiEntity = this.apiService.findById(this.api);
        return this.qualityMetricsService.getMetrics(apiEntity);
    }

    @POST
    @Path(value="/messages")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Send a message to existing consumers of an API", notes="User must have the API_MESSAGE[CREATE] permission to use this service")
    @Permissions(value={@Permission(value=RolePermission.API_MESSAGE, acls={RolePermissionAction.CREATE})})
    public Response createApiMessage(MessageEntity message) {
        return Response.ok((Object)this.messageService.create(this.api, message)).build();
    }

    @GET
    @Path(value="headers")
    @ApiOperation(value="Get the portal API headers values")
    @Produces(value={"application/json"})
    public List<ApiHeaderEntity> getPortalApiHeaders() {
        return this.apiService.getPortalHeaders(this.api);
    }

    @POST
    @Path(value="reviews")
    @ApiOperation(value="Manage the API's review state", notes="User must have the API_DEFINITION[UPDATE] or API_REVIEWS[UPDATE] permission to use this service (depending on the action)")
    @ApiResponses(value={@ApiResponse(code=204, message="Updated API"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DEFINITION, acls={RolePermissionAction.UPDATE}), @Permission(value=RolePermission.API_REVIEWS, acls={RolePermissionAction.UPDATE})})
    public Response doApiReviewAction(@Context HttpHeaders headers, @ApiParam(required=true, allowableValues="ASK") @NotNull @Valid @QueryParam(value="action") ReviewActionParam action, @ApiParam(name="review") @Valid ReviewEntity reviewEntity) {
        ApiEntity updatedApi;
        Response responseApi = this.getApi();
        Response.ResponseBuilder builder = this.evaluateIfMatch(headers, responseApi.getEntityTag().getValue());
        if (builder != null) {
            return builder.build();
        }
        ApiEntity apiEntity = (ApiEntity)responseApi.getEntity();
        this.checkApiReviewWorkflow(apiEntity, action.getAction());
        switch (action.getAction()) {
            case ASK: {
                this.hasPermission(RolePermission.API_DEFINITION, this.api, RolePermissionAction.UPDATE);
                updatedApi = this.apiService.askForReview(apiEntity.getId(), this.getAuthenticatedUser(), reviewEntity);
                break;
            }
            case ACCEPT: {
                this.hasPermission(RolePermission.API_REVIEWS, this.api, RolePermissionAction.UPDATE);
                updatedApi = this.apiService.acceptReview(apiEntity.getId(), this.getAuthenticatedUser(), reviewEntity);
                break;
            }
            case REJECT: {
                this.hasPermission(RolePermission.API_REVIEWS, this.api, RolePermissionAction.UPDATE);
                updatedApi = this.apiService.rejectReview(apiEntity.getId(), this.getAuthenticatedUser(), reviewEntity);
                break;
            }
            default: {
                updatedApi = null;
            }
        }
        return Response.noContent().tag(Long.toString(updatedApi.getUpdatedAt().getTime())).lastModified(updatedApi.getUpdatedAt()).build();
    }

    private void checkApiReviewWorkflow(ApiEntity api, ReviewActionParam.ReviewAction action) {
        if (ApiLifecycleState.ARCHIVED.equals((Object)api.getLifecycleState())) {
            throw new BadRequestException("Deleted API can not be reviewed");
        }
        if (api.getWorkflowState() != null) {
            switch (api.getWorkflowState()) {
                case IN_REVIEW: {
                    if (!ReviewActionParam.ReviewAction.ASK.equals((Object)action)) break;
                    throw new BadRequestException("Review is still in progress");
                }
                case DRAFT: {
                    if (!ReviewActionParam.ReviewAction.ACCEPT.equals((Object)action) && !ReviewActionParam.ReviewAction.REJECT.equals((Object)action)) break;
                    throw new BadRequestException("State invalid to accept/reject a review");
                }
            }
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="duplicate")
    @ApiOperation(value="Duplicate the API", notes="User must have the MANAGE_API create permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="API definition", response=ApiEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DEFINITION, acls={RolePermissionAction.READ}), @Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.CREATE})})
    public Response duplicateAPI(@ApiParam(name="api", required=true) @Valid @NotNull DuplicateApiEntity duplicateApiEntity) {
        ApiEntity apiEntity = (ApiEntity)this.getApi().getEntity();
        return Response.ok((Object)this.apiService.duplicate(apiEntity, duplicateApiEntity)).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="_migrate")
    @ApiOperation(value="Migrate the API definition to be used with Policy Studio", notes="User must have the MANAGE_API create permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="API definition", response=ApiEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DEFINITION, acls={RolePermissionAction.READ}), @Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.CREATE})})
    public Response migrateAPI() {
        return Response.ok((Object)this.apiService.migrate(this.api)).build();
    }

    @Path(value="keys")
    public ApiKeysResource getApiKeyResource() {
        return (ApiKeysResource)this.resourceContext.getResource(ApiKeysResource.class);
    }

    @Path(value="members")
    public ApiMembersResource getApiMembersResource() {
        return (ApiMembersResource)this.resourceContext.getResource(ApiMembersResource.class);
    }

    @Path(value="analytics")
    public ApiAnalyticsResource getApiAnalyticsResource() {
        return (ApiAnalyticsResource)this.resourceContext.getResource(ApiAnalyticsResource.class);
    }

    @Path(value="logs")
    public ApiLogsResource getApiLogsResource() {
        return (ApiLogsResource)this.resourceContext.getResource(ApiLogsResource.class);
    }

    @Path(value="health")
    public ApiHealthResource getApiHealthResource() {
        return (ApiHealthResource)this.resourceContext.getResource(ApiHealthResource.class);
    }

    @Path(value="pages")
    public ApiPagesResource getApiPagesResource() {
        return (ApiPagesResource)this.resourceContext.getResource(ApiPagesResource.class);
    }

    @Path(value="events")
    public ApiEventsResource getApiEventsResource() {
        return (ApiEventsResource)this.resourceContext.getResource(ApiEventsResource.class);
    }

    @Path(value="plans")
    public ApiPlansResource getApiPlansResource() {
        return (ApiPlansResource)this.resourceContext.getResource(ApiPlansResource.class);
    }

    @Path(value="subscriptions")
    public ApiSubscriptionsResource getApiSubscriptionsResource() {
        return (ApiSubscriptionsResource)this.resourceContext.getResource(ApiSubscriptionsResource.class);
    }

    @Path(value="subscribers")
    public ApiSubscribersResource geApiSubscribersResource() {
        return (ApiSubscribersResource)this.resourceContext.getResource(ApiSubscribersResource.class);
    }

    @Path(value="metadata")
    public ApiMetadataResource getApiMetadataResource() {
        return (ApiMetadataResource)this.resourceContext.getResource(ApiMetadataResource.class);
    }

    @Path(value="ratings")
    public ApiRatingResource getRatingResource() {
        return (ApiRatingResource)this.resourceContext.getResource(ApiRatingResource.class);
    }

    @Path(value="audit")
    public ApiAuditResource getApiAuditResource() {
        return (ApiAuditResource)this.resourceContext.getResource(ApiAuditResource.class);
    }

    @Path(value="notificationsettings")
    public ApiNotificationSettingsResource getNotificationSettingsResource() {
        return (ApiNotificationSettingsResource)this.resourceContext.getResource(ApiNotificationSettingsResource.class);
    }

    @Path(value="alerts")
    public ApiAlertsResource getApiAlertsResource() {
        return (ApiAlertsResource)this.resourceContext.getResource(ApiAlertsResource.class);
    }

    @Path(value="quality-rules")
    public ApiQualityRulesResource getApiQualityRulesResource() {
        return (ApiQualityRulesResource)this.resourceContext.getResource(ApiQualityRulesResource.class);
    }

    private void setSynchronizationState(ApiStateEntity apiStateEntity) {
        apiStateEntity.setIsSynchronized(this.apiService.isSynchronized(apiStateEntity.getApiId()));
    }

    private void checkApiLifeCycle(ApiEntity api, LifecycleActionParam.LifecycleAction action) {
        if (ApiLifecycleState.ARCHIVED.equals((Object)api.getLifecycleState())) {
            throw new BadRequestException("Deleted API can not be " + action.name().toLowerCase());
        }
        switch (api.getState()) {
            case STARTED: {
                if (!LifecycleActionParam.LifecycleAction.START.equals((Object)action)) break;
                throw new BadRequestException("API is already started");
            }
            case STOPPED: {
                if (LifecycleActionParam.LifecycleAction.STOP.equals((Object)action)) {
                    throw new BadRequestException("API is already stopped");
                }
                boolean apiReviewEnabled = this.parameterService.findAsBoolean(Key.API_REVIEW_ENABLED, ParameterReferenceType.ENVIRONMENT);
                if (!apiReviewEnabled || api.getWorkflowState() == null || WorkflowState.REVIEW_OK.equals((Object)api.getWorkflowState())) break;
                throw new BadRequestException("API can not be started without being reviewed");
            }
        }
    }

    private String getExportFilename(ApiEntity apiEntity) {
        return String.format("%s-%s.json", apiEntity.getName(), apiEntity.getVersion()).trim().toLowerCase().replaceAll(" +", " ").replaceAll(" ", "-").replaceAll("[^\\w\\s\\.]", "-").replaceAll("-+", "-");
    }

    private void filterSensitiveData(ApiEntity entity) {
        Proxy filteredProxy = new Proxy();
        VirtualHost virtualHost = (VirtualHost)entity.getProxy().getVirtualHosts().get(0);
        virtualHost.setHost(null);
        filteredProxy.setVirtualHosts(Collections.singletonList(virtualHost));
        entity.setProxy(filteredProxy);
        entity.setPaths(null);
        entity.setProperties(null);
        entity.setServices(null);
        entity.setResources(null);
        entity.setPathMappings(null);
        entity.setResponseTemplates(null);
    }
}

