/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.ApiMetadataEntity;
import io.gravitee.rest.api.model.NewApiMetadataEntity;
import io.gravitee.rest.api.model.UpdateApiMetadataEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.ApiMetadataService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.List;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Api(tags={"API Metadata"})
public class ApiMetadataResource
extends AbstractResource {
    @Inject
    private ApiMetadataService metadataService;
    @PathParam(value="api")
    @ApiParam(name="api", hidden=true)
    private String api;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="List metadata for the given API", notes="User must have the API_METADATA[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="List of metadata", response=ApiMetadataEntity.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_METADATA, acls={RolePermissionAction.READ})})
    public List<ApiMetadataEntity> getApiMetadatas() {
        return this.metadataService.findAllByApi(this.api);
    }

    @GET
    @Path(value="{metadata}")
    @Produces(value={"application/json"})
    @ApiOperation(value="A metadata for the given API and metadata id", notes="User must have the API_METADATA[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="A metadata", response=ApiMetadataEntity.class), @ApiResponse(code=404, message="Metadata not found"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_METADATA, acls={RolePermissionAction.READ})})
    public ApiMetadataEntity getApiMetadata(@PathParam(value="metadata") String metadata) {
        return this.metadataService.findByIdAndApi(metadata, this.api);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create an API metadata", notes="User must have the API_METADATA[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=201, message="A new API metadata", response=ApiMetadataEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_METADATA, acls={RolePermissionAction.CREATE})})
    public Response createApiMetadata(@Valid @NotNull NewApiMetadataEntity metadata) {
        metadata.setApiId(this.api);
        ApiMetadataEntity apiMetadataEntity = this.metadataService.create(metadata);
        return Response.created((URI)this.getLocationHeader(apiMetadataEntity.getKey())).entity((Object)apiMetadataEntity).build();
    }

    @PUT
    @Path(value="{metadata}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update an API metadata", notes="User must have the API_METADATA[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=201, message="API metadata", response=ApiMetadataEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_METADATA, acls={RolePermissionAction.UPDATE})})
    public Response updateApiMetadata(@PathParam(value="metadata") String metadataPathParam, @Valid @NotNull UpdateApiMetadataEntity metadata) {
        metadata.setApiId(this.api);
        return Response.ok((Object)this.metadataService.update(metadata)).build();
    }

    @DELETE
    @Path(value="{metadata}")
    @ApiOperation(value="Delete a metadata", notes="User must have the API_METADATA[DELETE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=204, message="Metadata successfully deleted"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_METADATA, acls={RolePermissionAction.DELETE})})
    public Response deleteApiMetadata(@PathParam(value="metadata") String metadata) {
        this.metadataService.delete(metadata, this.api);
        return Response.noContent().build();
    }
}

