/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.model.ApiMembership;
import io.gravitee.rest.api.management.rest.model.TransferOwnership;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.MemberEntity;
import io.gravitee.rest.api.model.MembershipListItem;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.permissions.ApiPermission;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.model.permissions.SystemRole;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.exceptions.SinglePrimaryOwnerException;
import io.gravitee.rest.api.service.exceptions.UserNotFoundException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Api(tags={"API Memberships"})
public class ApiMembersResource
extends AbstractResource {
    @Inject
    private UserService userService;
    @PathParam(value="api")
    @ApiParam(name="api", hidden=true)
    private String api;

    @GET
    @Path(value="/permissions")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get API members", notes="User must have the MANAGE_MEMBERS permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="API member's permissions", response=MemberEntity.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error")})
    public Response getApiMembersPermissions() {
        ApiEntity apiEntity = this.apiService.findById(this.api);
        Map<String, char[]> permissions = new HashMap();
        if (this.isAuthenticated()) {
            String userId = this.getAuthenticatedUser();
            if (this.isAdmin()) {
                char[] rights = new char[]{RolePermissionAction.CREATE.getId(), RolePermissionAction.READ.getId(), RolePermissionAction.UPDATE.getId(), RolePermissionAction.DELETE.getId()};
                for (ApiPermission perm : ApiPermission.values()) {
                    permissions.put(perm.getName(), rights);
                }
            } else {
                permissions = this.membershipService.getUserMemberPermissions(apiEntity, userId);
            }
        }
        return Response.ok(permissions).build();
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="List API members", notes="User must have the MANAGE_MEMBERS permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="List of API's members", response=MembershipListItem.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_MEMBER, acls={RolePermissionAction.READ})})
    public List<MembershipListItem> getApiMembers() {
        this.apiService.findById(this.api);
        return this.membershipService.getMembersByReference(MembershipReferenceType.API, this.api).stream().map(MembershipListItem::new).sorted(Comparator.comparing(MembershipListItem::getId)).collect(Collectors.toList());
    }

    @POST
    @ApiOperation(value="Add or update an API member", notes="User must have the MANAGE_MEMBERS permission to use this service")
    @ApiResponses(value={@ApiResponse(code=201, message="Member has been added or updated successfully"), @ApiResponse(code=400, message="Membership parameter is not valid"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_MEMBER, acls={RolePermissionAction.CREATE}), @Permission(value=RolePermission.API_MEMBER, acls={RolePermissionAction.UPDATE})})
    public Response addOrUpdateApiMember(@Valid @NotNull ApiMembership apiMembership) {
        MemberEntity userMember;
        if (SystemRole.PRIMARY_OWNER.name().equals(apiMembership.getRole())) {
            throw new SinglePrimaryOwnerException(RoleScope.API);
        }
        this.apiService.findById(this.api);
        MembershipService.MembershipReference reference = new MembershipService.MembershipReference(MembershipReferenceType.API, this.api);
        MembershipService.MembershipMember member = new MembershipService.MembershipMember(apiMembership.getId(), apiMembership.getReference(), MembershipMemberType.USER);
        MembershipService.MembershipRole role = new MembershipService.MembershipRole(RoleScope.API, apiMembership.getRole());
        MemberEntity membership = null;
        if (apiMembership.getId() != null && (userMember = this.membershipService.getUserMember(MembershipReferenceType.API, this.api, apiMembership.getId())) != null && userMember.getRoles() != null && !userMember.getRoles().isEmpty()) {
            membership = this.membershipService.updateRoleToMemberOnReference(reference, member, role);
        }
        if (membership == null) {
            this.membershipService.addRoleToMemberOnReference(reference, member, role);
        }
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @POST
    @Path(value="transfer_ownership")
    @ApiOperation(value="Transfer the ownership of the API", notes="User must have the TRANSFER_OWNERSHIP permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Ownership has been transferred successfully"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_MEMBER, acls={RolePermissionAction.UPDATE})})
    public Response transferApiMemberOwnership(@Valid @NotNull TransferOwnership transferOwnership) {
        ArrayList<RoleEntity> newRoles = new ArrayList<RoleEntity>();
        Optional optNewRole = this.roleService.findByScopeAndName(RoleScope.API, transferOwnership.getPoRole());
        if (optNewRole.isPresent()) {
            newRoles.add((RoleEntity)optNewRole.get());
        }
        this.apiService.findById(this.api);
        this.membershipService.transferApiOwnership(this.api, new MembershipService.MembershipMember(transferOwnership.getId(), transferOwnership.getReference(), MembershipMemberType.USER), newRoles);
        return Response.ok().build();
    }

    @DELETE
    @ApiOperation(value="Remove an API member", notes="User must have the MANAGE_MEMBERS permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Member has been removed successfully"), @ApiResponse(code=400, message="User does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_MEMBER, acls={RolePermissionAction.DELETE})})
    public Response deleteApiMember(@ApiParam(name="user", required=true) @NotNull @QueryParam(value="user") String userId) {
        this.apiService.findById(this.api);
        try {
            this.userService.findById(userId);
        }
        catch (UserNotFoundException unfe) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)unfe.getMessage()).build();
        }
        this.membershipService.deleteReferenceMember(MembershipReferenceType.API, this.api, MembershipMemberType.USER, userId);
        return Response.ok().build();
    }
}

