/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.v4.entrypoint;

import io.gravitee.rest.api.management.rest.resource.v4.connector.AbstractConnectorsResource;
import io.gravitee.rest.api.management.rest.resource.v4.entrypoint.EntrypointResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.ConnectorListItem;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.v4.connector.ConnectorExpandPluginEntity;
import io.gravitee.rest.api.service.v4.EntrypointConnectorPluginService;
import io.swagger.annotations.ApiParam;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;

@Tag(name="\ud83e\uddea V4 - Entrypoints")
public class EntrypointsResource
extends AbstractConnectorsResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private EntrypointConnectorPluginService entrypointService;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="\ud83e\uddea List entrypoint plugins", description="\u26a0\ufe0f This resource is in alpha version. This implies that it is likely to be modified or even removed in future versions. \u26a0\ufe0f. <br><br>User must have the ENVIRONMENT_API[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of entrypoints", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ConnectorListItem.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.READ})})
    public Collection<ConnectorExpandPluginEntity> getEntrypoints(@QueryParam(value="expand") @ApiParam(name="expand", allowableValues="schema, icon, subscriptionSchema", allowMultiple=true) List<String> expands) {
        Collection<ConnectorExpandPluginEntity> connectors = super.expand(this.entrypointService.findAll(), expands);
        if (expands != null && expands.contains("subscriptionSchema")) {
            connectors.forEach(connector -> connector.setSubscriptionSchema(this.entrypointService.getSubscriptionSchema(connector.getId())));
        }
        return connectors;
    }

    @Override
    protected String getSchema(String connectorId) {
        return this.entrypointService.getSchema(connectorId);
    }

    @Override
    protected String getIcon(String connectorId) {
        return this.entrypointService.getIcon(connectorId);
    }

    @Path(value="{entrypoint}")
    public EntrypointResource getEntrypointResource() {
        return (EntrypointResource)this.resourceContext.getResource(EntrypointResource.class);
    }
}

