/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.v4.api;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.v4.param.PlanSecurityParam;
import io.gravitee.rest.api.management.rest.resource.v4.param.PlanStatusParam;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.model.v4.plan.NewPlanEntity;
import io.gravitee.rest.api.model.v4.plan.PlanEntity;
import io.gravitee.rest.api.model.v4.plan.PlanSecurityType;
import io.gravitee.rest.api.model.v4.plan.PlanType;
import io.gravitee.rest.api.model.v4.plan.UpdatePlanEntity;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.ForbiddenAccessException;
import io.gravitee.rest.api.service.v4.PlanService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.Explode;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Tag(name="\ud83e\uddea V4 - API Plans")
public class ApiPlansResource
extends AbstractResource {
    @Inject
    private PlanService planService;
    @Inject
    private GroupService groupService;
    @Context
    private ResourceContext resourceContext;
    @PathParam(value="api")
    @Parameter(name="api", hidden=true)
    private String apiId;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="\ud83e\uddea List plans for an API", description="\u26a0\ufe0f This resource is in alpha version. This implies that it is likely to be modified or even removed in future versions. \u26a0\ufe0f. <br><br>List all the plans accessible to the current user.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List accessible plans for current user", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=PlanEntity.class), uniqueItems=true))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public List<PlanEntity> getApiPlans(@QueryParam(value="status") @DefaultValue(value="PUBLISHED") @Parameter(explode=Explode.FALSE, schema=@Schema(type="array")) PlanStatusParam wishedStatus, @QueryParam(value="security") @Parameter(explode=Explode.FALSE, schema=@Schema(type="array")) PlanSecurityParam security) {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        if (!this.hasPermission(executionContext, RolePermission.API_PLAN, this.apiId, RolePermissionAction.READ) && !this.hasPermission(executionContext, RolePermission.API_LOG, this.apiId, RolePermissionAction.READ)) {
            throw new ForbiddenAccessException();
        }
        GenericApiEntity genericApiEntity = this.apiSearchService.findGenericById(executionContext, this.apiId);
        return this.planService.findByApi(executionContext, this.apiId).stream().filter(plan -> wishedStatus.contains(plan.getStatus()) && (this.isAuthenticated() && this.isAdmin() || this.groupService.isUserAuthorizedToAccessApiData(genericApiEntity, plan.getExcludedGroups(), this.getAuthenticatedUserOrNull()))).filter(plan -> security == null || security.contains(PlanSecurityType.valueOfLabel((String)plan.getSecurity().getType()))).sorted(Comparator.comparingInt(PlanEntity::getOrder)).map(this::filterSensitiveData).collect(Collectors.toList());
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="\ud83e\uddea Create a plan", description="\u26a0\ufe0f This resource is in alpha version. This implies that it is likely to be modified or even removed in future versions. \u26a0\ufe0f. <br><br>User must have the MANAGE_PLANS permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Plan successfully created", content={@Content(mediaType="application/json", schema=@Schema(implementation=PlanEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_PLAN, acls={RolePermissionAction.CREATE})})
    public Response createApiPlan(@Parameter(name="plan", required=true) @Valid @NotNull NewPlanEntity newPlanEntity) {
        newPlanEntity.setApiId(this.apiId);
        newPlanEntity.setType(PlanType.API);
        PlanEntity planEntity = this.planService.create(GraviteeContext.getExecutionContext(), newPlanEntity);
        return Response.created((URI)this.getLocationHeader(planEntity.getId())).entity((Object)planEntity).build();
    }

    @PUT
    @Path(value="/{plan}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="\ud83e\uddea Update a plan", description="\u26a0\ufe0f This resource is in alpha version. This implies that it is likely to be modified or even removed in future versions. \u26a0\ufe0f. <br><br>User must have the MANAGE_PLANS permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Plan successfully updated", content={@Content(mediaType="application/json", schema=@Schema(implementation=PlanEntity.class))}), @ApiResponse(responseCode="400", description="Bad plan format"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_PLAN, acls={RolePermissionAction.UPDATE})})
    public Response updateApiPlan(@PathParam(value="plan") String plan, @Parameter(name="plan", required=true) @Valid @NotNull UpdatePlanEntity updatePlanEntity) {
        if (updatePlanEntity.getId() != null && !plan.equals(updatePlanEntity.getId())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'plan' parameter does not correspond to the plan to update").build();
        }
        updatePlanEntity.setId(plan);
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        PlanEntity planEntity = this.planService.findById(executionContext, plan);
        if (!planEntity.getApiId().equals(this.apiId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'plan' parameter does not correspond to the current API").build();
        }
        planEntity = this.planService.update(executionContext, updatePlanEntity);
        return Response.ok((Object)planEntity).build();
    }

    @GET
    @Path(value="/{plan}")
    @Produces(value={"application/json"})
    @Operation(summary="\ud83e\uddea Get a plan", description="\u26a0\ufe0f This resource is in alpha version. This implies that it is likely to be modified or even removed in future versions. \u26a0\ufe0f. <br><br>User must have the READ permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Plan information", content={@Content(mediaType="application/json", schema=@Schema(implementation=PlanEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getApiPlan(@PathParam(value="plan") String plan) {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        if (Visibility.PUBLIC.equals((Object)this.apiService.findById(executionContext, this.apiId).getVisibility()) || this.hasPermission(GraviteeContext.getExecutionContext(), RolePermission.API_PLAN, this.apiId, RolePermissionAction.READ)) {
            PlanEntity planEntity = this.planService.findById(executionContext, plan);
            if (!planEntity.getApiId().equals(this.apiId)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'plan' parameter does not correspond to the current API").build();
            }
            return Response.ok((Object)planEntity).build();
        }
        throw new ForbiddenAccessException();
    }

    @DELETE
    @Path(value="/{plan}")
    @Produces(value={"application/json"})
    @Operation(summary="\ud83e\uddea Delete a plan", description="\u26a0\ufe0f This resource is in alpha version. This implies that it is likely to be modified or even removed in future versions. \u26a0\ufe0f. <br><br>User must have the MANAGE_PLANS permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Plan successfully deleted"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_PLAN, acls={RolePermissionAction.DELETE})})
    public Response deleteApiPlan(@PathParam(value="plan") String plan) {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        PlanEntity planEntity = this.planService.findById(executionContext, plan);
        if (!planEntity.getApiId().equals(this.apiId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'plan' parameter does not correspond to the current API").build();
        }
        this.planService.delete(executionContext, plan);
        return Response.noContent().build();
    }

    @POST
    @Path(value="/{plan}/_close")
    @Produces(value={"application/json"})
    @Operation(summary="\ud83e\uddea Close  a plan", description="\u26a0\ufe0f This resource is in alpha version. This implies that it is likely to be modified or even removed in future versions. \u26a0\ufe0f. <br><br>User must have the MANAGE_PLANS permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Plan successfully closed", content={@Content(mediaType="application/json", schema=@Schema(implementation=PlanEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_PLAN, acls={RolePermissionAction.UPDATE})})
    public Response closeApiPlan(@PathParam(value="plan") String plan) {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        PlanEntity planEntity = this.planService.findById(executionContext, plan);
        if (!planEntity.getApiId().equals(this.apiId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'plan' parameter does not correspond to the current API").build();
        }
        PlanEntity closedPlan = this.planService.close(executionContext, plan);
        return Response.ok((Object)closedPlan).build();
    }

    @POST
    @Path(value="/{plan}/_publish")
    @Produces(value={"application/json"})
    @Operation(summary="\ud83e\uddea Publicly publish plan", description="\u26a0\ufe0f This resource is in alpha version. This implies that it is likely to be modified or even removed in future versions. \u26a0\ufe0f. <br><br>User must have the MANAGE_PLANS permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Plan successfully published", content={@Content(mediaType="application/json", schema=@Schema(implementation=PlanEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_PLAN, acls={RolePermissionAction.UPDATE})})
    public Response publishApiPlan(@PathParam(value="plan") String plan) {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        PlanEntity planEntity = this.planService.findById(executionContext, plan);
        if (!planEntity.getApiId().equals(this.apiId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'plan' parameter does not correspond to the current API").build();
        }
        return Response.ok((Object)this.planService.publish(executionContext, plan)).build();
    }

    @POST
    @Deprecated
    @Path(value="/{plan}/_depreciate")
    @Produces(value={"application/json"})
    @Operation(summary="\ud83e\uddea Deprecated, use '_deprecate' instead. Deprecate a plan", deprecated=true, description="\u26a0\ufe0f This resource is in alpha version. This implies that it is likely to be modified or even removed in future versions. \u26a0\ufe0f. <br><br>User must have the API_PLAN[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Plan successfully deprecated", content={@Content(mediaType="application/json", schema=@Schema(implementation=PlanEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_PLAN, acls={RolePermissionAction.UPDATE})})
    public Response depreciateApiPlan(@PathParam(value="plan") String plan) {
        return this.deprecateApiPlan(plan);
    }

    @POST
    @Path(value="/{plan}/_deprecate")
    @Produces(value={"application/json"})
    @Operation(summary="\ud83e\uddea Deprecate a plan", description="\u26a0\ufe0f This resource is in alpha version. This implies that it is likely to be modified or even removed in future versions. \u26a0\ufe0f. <br><br>User must have the API_PLAN[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Plan successfully deprecated", content={@Content(mediaType="application/json", schema=@Schema(implementation=PlanEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_PLAN, acls={RolePermissionAction.UPDATE})})
    public Response deprecateApiPlan(@PathParam(value="plan") String plan) {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        PlanEntity planEntity = this.planService.findById(executionContext, plan);
        if (!planEntity.getApiId().equals(this.apiId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'plan' parameter does not correspond to the current API").build();
        }
        return Response.ok((Object)this.planService.deprecate(executionContext, plan)).build();
    }

    private PlanEntity filterSensitiveData(PlanEntity entity) {
        if (this.hasPermission(GraviteeContext.getExecutionContext(), RolePermission.API_GATEWAY_DEFINITION, entity.getApiId(), RolePermissionAction.READ) && this.hasPermission(GraviteeContext.getExecutionContext(), RolePermission.API_PLAN, entity.getApiId(), RolePermissionAction.READ)) {
            return entity;
        }
        PlanEntity filtered = new PlanEntity();
        filtered.setId(entity.getId());
        filtered.setCharacteristics(entity.getCharacteristics());
        filtered.setName(entity.getName());
        filtered.setDescription(entity.getDescription());
        filtered.setOrder(entity.getOrder());
        filtered.setSecurity(entity.getSecurity());
        filtered.setType(filtered.getType());
        filtered.setValidation(filtered.getValidation());
        filtered.setCommentRequired(entity.isCommentRequired());
        filtered.setCommentMessage(entity.getCommentMessage());
        filtered.setGeneralConditions(entity.getGeneralConditions());
        return filtered;
    }
}

