/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.param;

import io.gravitee.rest.api.management.rest.resource.param.EventTypeListParam;
import io.gravitee.rest.api.management.rest.resource.param.ListStringParam;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.Explode;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import lombok.Generated;

public class EventSearchParam {
    @QueryParam(value="type")
    @Parameter(explode=Explode.FALSE, schema=@Schema(type="array"))
    private EventTypeListParam eventTypeListParam;
    @QueryParam(value="from")
    private Long from;
    @QueryParam(value="to")
    private Long to;
    @QueryParam(value="page")
    @DefaultValue(value="0")
    private Integer page;
    @QueryParam(value="size")
    @DefaultValue(value="10")
    private Integer size;
    @QueryParam(value="api_ids")
    @Parameter(explode=Explode.FALSE, schema=@Schema(type="array"))
    private ListStringParam apiIdsParam;
    @QueryParam(value="withPayload")
    private boolean withPayload;

    public void validate() throws WebApplicationException {
        if (this.from == -1L) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Query parameter 'from' is not valid").build());
        }
        if (this.to == -1L) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Query parameter 'to' is not valid").build());
        }
        if (this.page == -1) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Query parameter 'page' is not valid").build());
        }
        if (this.size < 0 || this.size > 100) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Query parameter 'size' must be >= 0 and <= 100").build());
        }
        if (this.from >= this.to) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'from' query parameter value must be greater than 'to'").build());
        }
    }

    @Generated
    public EventTypeListParam getEventTypeListParam() {
        return this.eventTypeListParam;
    }

    @Generated
    public Long getFrom() {
        return this.from;
    }

    @Generated
    public Long getTo() {
        return this.to;
    }

    @Generated
    public Integer getPage() {
        return this.page;
    }

    @Generated
    public Integer getSize() {
        return this.size;
    }

    @Generated
    public ListStringParam getApiIdsParam() {
        return this.apiIdsParam;
    }

    @Generated
    public boolean isWithPayload() {
        return this.withPayload;
    }

    @Generated
    public void setEventTypeListParam(EventTypeListParam eventTypeListParam) {
        this.eventTypeListParam = eventTypeListParam;
    }

    @Generated
    public void setFrom(Long from) {
        this.from = from;
    }

    @Generated
    public void setTo(Long to) {
        this.to = to;
    }

    @Generated
    public void setPage(Integer page) {
        this.page = page;
    }

    @Generated
    public void setSize(Integer size) {
        this.size = size;
    }

    @Generated
    public void setApiIdsParam(ListStringParam apiIdsParam) {
        this.apiIdsParam = apiIdsParam;
    }

    @Generated
    public void setWithPayload(boolean withPayload) {
        this.withPayload = withPayload;
    }
}

