/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.param.Aggregation;
import io.gravitee.rest.api.management.rest.resource.param.AnalyticsParam;
import io.gravitee.rest.api.management.rest.resource.param.Range;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.analytics.Analytics;
import io.gravitee.rest.api.model.analytics.query.AbstractQuery;
import io.gravitee.rest.api.model.analytics.query.AggregationType;
import io.gravitee.rest.api.model.analytics.query.CountQuery;
import io.gravitee.rest.api.model.analytics.query.DateHistogramQuery;
import io.gravitee.rest.api.model.analytics.query.GroupByQuery;
import io.gravitee.rest.api.model.analytics.query.StatsQuery;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.AnalyticsService;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.ApplicationService;
import io.gravitee.rest.api.service.PermissionService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.BeanParam;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jetbrains.annotations.NotNull;

@Tag(name="Platform Analytics")
public class PlatformAnalyticsResource
extends AbstractResource {
    @Inject
    ApiService apiService;
    @Inject
    PermissionService permissionService;
    @Inject
    ApplicationService applicationService;
    @Inject
    private AnalyticsService analyticsService;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get platform analytics", description="User must have the MANAGEMENT_PLATFORM[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Platform analytics", content={@Content(mediaType="application/json", schema=@Schema(implementation=Analytics.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_PLATFORM, acls={RolePermissionAction.READ})})
    public Response getPlatformAnalytics(@BeanParam AnalyticsParam analyticsParam) {
        Set<String> ids;
        String fieldName;
        analyticsParam.validate();
        if ("application".equals(analyticsParam.getField())) {
            fieldName = "application";
            ids = this.findApplicationIds();
        } else {
            fieldName = "api";
            ids = this.findApiIds();
        }
        if (ids.isEmpty()) {
            return Response.noContent().build();
        }
        String extraFilter = this.getExtraFilter(fieldName, ids);
        if (analyticsParam.getQuery() != null) {
            analyticsParam.setQuery(analyticsParam.getQuery().replaceAll("\\?", "1"));
        }
        Analytics analytics = null;
        switch (analyticsParam.getType()) {
            case DATE_HISTO: {
                analytics = this.executeDateHisto(analyticsParam, extraFilter);
                break;
            }
            case GROUP_BY: {
                analytics = this.executeGroupBy(analyticsParam, extraFilter);
                break;
            }
            case COUNT: {
                analytics = this.executeCount(analyticsParam, extraFilter);
                break;
            }
            case STATS: {
                analytics = this.executeStats(analyticsParam, extraFilter);
            }
        }
        return Response.ok(analytics).build();
    }

    @NotNull
    private Set<String> findApiIds() {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        if (this.isAdmin()) {
            return this.apiAuthorizationService.findIdsByEnvironment(executionContext);
        }
        return this.apiAuthorizationService.findIdsByUser(executionContext, this.getAuthenticatedUser(), true).stream().filter(appId -> this.permissionService.hasPermission(executionContext, RolePermission.API_ANALYTICS, appId, new RolePermissionAction[]{RolePermissionAction.READ})).collect(Collectors.toSet());
    }

    @NotNull
    private Set<String> findApplicationIds() {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        if (this.isAdmin()) {
            return this.applicationService.findIdsByUser(executionContext, null);
        }
        return this.applicationService.findIdsByUser(executionContext, this.getAuthenticatedUser()).stream().filter(appId -> this.permissionService.hasPermission(executionContext, RolePermission.APPLICATION_ANALYTICS, appId, new RolePermissionAction[]{RolePermissionAction.READ})).collect(Collectors.toSet());
    }

    private Analytics executeStats(AnalyticsParam analyticsParam, String extraFilter) {
        StatsQuery query = new StatsQuery();
        query.setFrom(analyticsParam.getFrom());
        query.setTo(analyticsParam.getTo());
        query.setInterval(analyticsParam.getInterval());
        query.setQuery(analyticsParam.getQuery());
        query.setField(analyticsParam.getField());
        this.addExtraFilter((AbstractQuery)query, extraFilter);
        return this.analyticsService.execute(query);
    }

    private Analytics executeCount(AnalyticsParam analyticsParam, String extraFilter) {
        CountQuery query = new CountQuery();
        query.setFrom(analyticsParam.getFrom());
        query.setTo(analyticsParam.getTo());
        query.setInterval(analyticsParam.getInterval());
        query.setQuery(analyticsParam.getQuery());
        this.addExtraFilter((AbstractQuery)query, extraFilter);
        return this.analyticsService.execute(query);
    }

    private Analytics executeDateHisto(AnalyticsParam analyticsParam, String extraFilter) {
        DateHistogramQuery query = new DateHistogramQuery();
        query.setFrom(analyticsParam.getFrom());
        query.setTo(analyticsParam.getTo());
        query.setInterval(analyticsParam.getInterval());
        query.setQuery(analyticsParam.getQuery());
        List<Aggregation> aggregations = analyticsParam.getAggregations();
        if (aggregations != null) {
            List aggregationList = aggregations.stream().map(aggregation -> new io.gravitee.rest.api.model.analytics.query.Aggregation((Aggregation)aggregation){
                final /* synthetic */ Aggregation val$aggregation;
                {
                    this.val$aggregation = aggregation;
                }

                public AggregationType type() {
                    return AggregationType.valueOf((String)this.val$aggregation.getType().name().toUpperCase());
                }

                public String field() {
                    return this.val$aggregation.getField();
                }
            }).collect(Collectors.toList());
            query.setAggregations(aggregationList);
        }
        this.addExtraFilter((AbstractQuery)query, extraFilter);
        return this.analyticsService.execute(GraviteeContext.getExecutionContext(), query);
    }

    private Analytics executeGroupBy(AnalyticsParam analyticsParam, String extraFilter) {
        List<Range> ranges;
        GroupByQuery query = new GroupByQuery();
        query.setFrom(analyticsParam.getFrom());
        query.setTo(analyticsParam.getTo());
        query.setInterval(analyticsParam.getInterval());
        query.setQuery(analyticsParam.getQuery());
        query.setField(analyticsParam.getField());
        if (analyticsParam.getOrder() != null) {
            GroupByQuery.Order order = new GroupByQuery.Order();
            order.setField(analyticsParam.getOrder().getField());
            order.setType(analyticsParam.getOrder().getType());
            order.setOrder(analyticsParam.getOrder().isOrder());
            query.setOrder(order);
        }
        if ((ranges = analyticsParam.getRanges()) != null) {
            Map<Double, Double> rangeMap = ranges.stream().collect(Collectors.toMap(Range::getFrom, Range::getTo));
            query.setGroups(rangeMap);
        }
        this.addExtraFilter((AbstractQuery)query, extraFilter);
        return this.analyticsService.execute(GraviteeContext.getExecutionContext(), query);
    }

    private void addExtraFilter(AbstractQuery query, String extraFilter) {
        if (query.getQuery() == null || query.getQuery().isEmpty()) {
            query.setQuery(extraFilter);
        } else if (extraFilter != null && !extraFilter.isEmpty()) {
            query.setQuery(query.getQuery() + " AND " + extraFilter);
        } else {
            query.setQuery(query.getQuery());
        }
    }

    private String getExtraFilter(String fieldName, Set<String> ids) {
        if (ids != null && !ids.isEmpty()) {
            return fieldName + ":(" + ids.stream().collect(Collectors.joining(" OR ")) + ")";
        }
        return null;
    }
}

