/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.provider;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang3.StringUtils;

@Provider
public class EnumParamConverterProvider
implements ParamConverterProvider {
    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (!rawType.isEnum()) {
            return null;
        }
        Class<T> type = rawType;
        final Enum[] constants = (Enum[])type.getEnumConstants();
        return new ParamConverter<T>(){

            public T fromString(String value) {
                if (StringUtils.isEmpty((CharSequence)value)) {
                    return null;
                }
                for (Enum constant : constants) {
                    if (!constant.name().equalsIgnoreCase(value)) continue;
                    return constant;
                }
                return null;
            }

            public String toString(T value) {
                return value.toString();
            }
        };
    }
}

