/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.v4.endpoint;

import io.gravitee.rest.api.management.rest.resource.v4.connector.AbstractConnectorsResource;
import io.gravitee.rest.api.management.rest.resource.v4.entrypoint.EntrypointResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.ConnectorListItem;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.v4.connector.ConnectorExpandPluginEntity;
import io.gravitee.rest.api.service.v4.EndpointConnectorPluginService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;

@Tag(name="\ud83e\uddea V4 - Endpoints")
public class EndpointsResource
extends AbstractConnectorsResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private EndpointConnectorPluginService endpointService;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List endpoint plugins", description="User must have the ENVIRONMENT_API[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of endpoints", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ConnectorListItem.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.READ})})
    public Collection<ConnectorExpandPluginEntity> getEndpoints(@QueryParam(value="expand") List<String> expands) {
        return super.expand(this.endpointService.findAll(), expands);
    }

    @Path(value="{entrypoint}")
    public EntrypointResource getEntrypointResource() {
        return (EntrypointResource)this.resourceContext.getResource(EntrypointResource.class);
    }

    @Override
    protected String getSchema(String connectorId) {
        return this.endpointService.getSchema(connectorId);
    }

    @Override
    protected String getIcon(String connectorId) {
        return this.endpointService.getIcon(connectorId);
    }
}

