/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.model.Subscription;
import io.gravitee.rest.api.model.ApplicationEntity;
import io.gravitee.rest.api.model.PlanEntity;
import io.gravitee.rest.api.model.SubscriptionEntity;
import io.gravitee.rest.api.service.ApplicationService;
import io.gravitee.rest.api.service.PlanService;
import io.gravitee.rest.api.service.SubscriptionService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Tag(name="Subscription")
public class SubscriptionsResource {
    @Inject
    private SubscriptionService subscriptionService;
    @Inject
    private ApplicationService applicationService;
    @Inject
    private PlanService planService;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List subscriptions for authenticated user")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of subscriptions", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=Subscription.class), uniqueItems=true))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public Set<Subscription> getUserSubscriptions(@QueryParam(value="application") String application, @QueryParam(value="plan") String plan) {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        return this.subscriptionService.findByApplicationAndPlan(executionContext, application, plan).stream().map(subscriptionEntity -> this.convert(executionContext, (SubscriptionEntity)subscriptionEntity)).collect(Collectors.toSet());
    }

    private Subscription convert(ExecutionContext executionContext, SubscriptionEntity subscriptionEntity) {
        Subscription subscription = new Subscription();
        subscription.setId(subscriptionEntity.getId());
        subscription.setCreatedAt(subscriptionEntity.getCreatedAt());
        subscription.setUpdatedAt(subscriptionEntity.getUpdatedAt());
        subscription.setStartingAt(subscriptionEntity.getStartingAt());
        subscription.setEndingAt(subscriptionEntity.getEndingAt());
        subscription.setProcessedAt(subscriptionEntity.getProcessedAt());
        subscription.setProcessedBy(subscriptionEntity.getProcessedBy());
        subscription.setReason(subscriptionEntity.getReason());
        subscription.setStatus(subscriptionEntity.getStatus());
        subscription.setMetadata(subscriptionEntity.getMetadata());
        ApplicationEntity application = this.applicationService.findById(executionContext, subscriptionEntity.getApplication());
        subscription.setApplication(new Subscription.Application(application.getId(), application.getName(), application.getType(), application.getDescription(), application.getDomain(), new Subscription.User(application.getPrimaryOwner().getId(), application.getPrimaryOwner().getDisplayName()), application.getApiKeyMode()));
        PlanEntity plan = this.planService.findById(executionContext, subscriptionEntity.getPlan());
        subscription.setPlan(new Subscription.Plan(plan.getId(), plan.getName()));
        subscription.setClosedAt(subscriptionEntity.getClosedAt());
        return subscription;
    }
}

