/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.v4.endpoint;

import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.platform.plugin.PlatformPluginEntity;
import io.gravitee.rest.api.model.v4.connector.ConnectorPluginEntity;
import io.gravitee.rest.api.service.v4.EntrypointConnectorPluginService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;

@Tag(name="\ud83e\uddea V4 - Endpoints")
public class EndpointResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private EntrypointConnectorPluginService endpointService;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get an endpoint", description="User must have the ENVIRONMENT_API[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Entrypoint plugin", content={@Content(mediaType="application/json", schema=@Schema(implementation=PlatformPluginEntity.class))}), @ApiResponse(responseCode="404", description="Entrypoint not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.READ})})
    public ConnectorPluginEntity getEntrypoint(@PathParam(value="endpoint") String endpoint) {
        return (ConnectorPluginEntity)this.endpointService.findById(endpoint);
    }

    @GET
    @Path(value="schema")
    @Produces(value={"application/json"})
    @Operation(summary="Get a endpoint's schema", description="User must have the ENVIRONMENT_API[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Entrypoint schema", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="404", description="Entrypoint not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.READ})})
    public String getEntrypointSchema(@PathParam(value="endpoint") String endpoint) {
        this.endpointService.findById(endpoint);
        return this.endpointService.getSchema(endpoint);
    }

    @GET
    @Path(value="documentation")
    @Produces(value={"text/plain"})
    @Operation(summary="Get a endpoint's documentation", description="User must have the ENVIRONMENT_API[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Entrypoint documentation", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="404", description="Entrypoint not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.READ})})
    public String getEntrypointDoc(@PathParam(value="endpoint") String endpoint) {
        this.endpointService.findById(endpoint);
        return this.endpointService.getDocumentation(endpoint);
    }
}

