/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.v4.api;

import io.gravitee.definition.model.v4.listener.Listener;
import io.gravitee.definition.model.v4.listener.ListenerType;
import io.gravitee.definition.model.v4.listener.http.HttpListener;
import io.gravitee.rest.api.exception.InvalidImageException;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.ApiEventsResource;
import io.gravitee.rest.api.management.rest.resource.ApiGroupsResource;
import io.gravitee.rest.api.management.rest.resource.ApiMembersResource;
import io.gravitee.rest.api.management.rest.resource.ApiMetadataResource;
import io.gravitee.rest.api.management.rest.resource.ApiPagesResource;
import io.gravitee.rest.api.management.rest.resource.ApiRatingResource;
import io.gravitee.rest.api.management.rest.resource.ApiSubscribersResource;
import io.gravitee.rest.api.management.rest.resource.ApiSubscriptionsResource;
import io.gravitee.rest.api.management.rest.resource.param.LifecycleAction;
import io.gravitee.rest.api.management.rest.resource.v4.api.ApiPlansResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.WorkflowState;
import io.gravitee.rest.api.model.api.ApiDeploymentEntity;
import io.gravitee.rest.api.model.api.ApiLifecycleState;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.v4.api.ApiEntity;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.model.v4.api.UpdateApiEntity;
import io.gravitee.rest.api.security.utils.ImageUtils;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.ForbiddenAccessException;
import io.gravitee.rest.api.service.v4.ApiStateService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;

@Tag(name="\ud83e\uddea V4 - APIs")
public class ApiResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private ParameterService parameterService;
    @Inject
    private ApiStateService apiStateService;
    @PathParam(value="api")
    @Parameter(name="api", required=true, description="The ID of the API")
    private String api;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="\ud83e\uddea Get the API", description="\u26a0\ufe0f This resource is in alpha version. This implies that it is likely to be modified or even removed in future versions. \u26a0\ufe0f. <br><br>User must have the READ permission on the API_DEFINITION to use this service on a private API.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="API definition", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getApi() {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        ApiEntity apiEntity = this.apiSearchService.findById(executionContext, this.api);
        if (!this.canManageApi((GenericApiEntity)apiEntity)) {
            throw new ForbiddenAccessException();
        }
        if (this.hasPermission(executionContext, RolePermission.API_DEFINITION, this.api, RolePermissionAction.READ)) {
            this.setPictures(apiEntity);
        } else {
            this.filterSensitiveData(apiEntity);
        }
        return Response.ok((Object)apiEntity).tag(Long.toString(apiEntity.getUpdatedAt().getTime())).lastModified(apiEntity.getUpdatedAt()).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="\ud83e\uddea Update the API", description="\u26a0\ufe0f This resource is in alpha version. This implies that it is likely to be modified or even removed in future versions. \u26a0\ufe0f. <br><br>User must have the MANAGE_API permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="API successfully updated", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DEFINITION, acls={RolePermissionAction.UPDATE}), @Permission(value=RolePermission.API_GATEWAY_DEFINITION, acls={RolePermissionAction.UPDATE})})
    public Response updateApi(@Context HttpHeaders headers, @Valid @NotNull UpdateApiEntity apiToUpdate) {
        if (!this.api.equals(apiToUpdate.getId())) {
            throw new BadRequestException("'apiId' is not the same that the API in payload");
        }
        Response responseApi = this.getApi();
        Response.ResponseBuilder builder = this.evaluateIfMatch(headers, responseApi.getEntityTag().getValue());
        if (builder != null) {
            return builder.build();
        }
        try {
            ImageUtils.verify((String)apiToUpdate.getPicture());
            ImageUtils.verify((String)apiToUpdate.getBackground());
        }
        catch (InvalidImageException e) {
            throw new BadRequestException("Invalid image format");
        }
        ApiEntity currentApi = (ApiEntity)responseApi.getEntity();
        if (!(this.hasPermission(GraviteeContext.getExecutionContext(), RolePermission.API_GATEWAY_DEFINITION, this.api, RolePermissionAction.UPDATE) || Objects.equals(currentApi.getPrimaryOwner().getId(), this.getAuthenticatedUser()) || this.isAdmin())) {
            apiToUpdate.setListeners(currentApi.getListeners());
        }
        ApiEntity updatedApi = this.apiServiceV4.update(GraviteeContext.getExecutionContext(), this.api, apiToUpdate, true, this.getAuthenticatedUser());
        this.setPictures(updatedApi);
        return Response.ok((Object)updatedApi).tag(Long.toString(updatedApi.getUpdatedAt().getTime())).lastModified(updatedApi.getUpdatedAt()).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="deploy")
    @Operation(summary="\ud83e\uddea Deploy API to gateway instances", description="\u26a0\ufe0f This resource is in alpha version. This implies that it is likely to be modified or even removed in future versions. \u26a0\ufe0f. <br><br>User must have the MANAGE_LIFECYCLE permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="API successfully deployed", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DEFINITION, acls={RolePermissionAction.UPDATE})})
    public Response deployApi(@Parameter(name="apiDeployment") @Valid ApiDeploymentEntity apiDeploymentEntity) {
        try {
            ApiEntity apiEntity = this.apiStateService.deploy(GraviteeContext.getExecutionContext(), this.api, this.getAuthenticatedUser(), apiDeploymentEntity);
            return Response.ok((Object)apiEntity).tag(Long.toString(apiEntity.getUpdatedAt().getTime())).lastModified(apiEntity.getUpdatedAt()).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("JsonProcessingException " + e)).build();
        }
    }

    @DELETE
    @Operation(summary="\ud83e\uddea Delete the API", description="\u26a0\ufe0f This resource is in alpha version. This implies that it is likely to be modified or even removed in future versions. \u26a0\ufe0f. <br><br>User must have the DELETE permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="API successfully deleted"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DEFINITION, acls={RolePermissionAction.DELETE})})
    public Response deleteApi(@QueryParam(value="closePlans") boolean closePlans) {
        this.apiServiceV4.delete(GraviteeContext.getExecutionContext(), this.api, closePlans);
        return Response.noContent().build();
    }

    private void setPictures(ApiEntity apiEntity) {
        UriBuilder uriBuilder = this.uriInfo.getAbsolutePathBuilder().path("picture");
        uriBuilder.queryParam("hash", new Object[]{apiEntity.getUpdatedAt().getTime()});
        apiEntity.setPictureUrl(uriBuilder.build(new Object[0]).toString());
        apiEntity.setPicture(null);
        uriBuilder = this.uriInfo.getAbsolutePathBuilder().path("background");
        uriBuilder.queryParam("hash", new Object[]{apiEntity.getUpdatedAt().getTime()});
        apiEntity.setBackgroundUrl(uriBuilder.build(new Object[0]).toString());
        apiEntity.setBackground(null);
    }

    private void filterSensitiveData(ApiEntity apiEntity) {
        Optional<Listener> first;
        List listeners = apiEntity.getListeners();
        if (listeners != null && (first = listeners.stream().filter(listener -> ListenerType.HTTP == listener.getType()).findFirst()).isPresent()) {
            HttpListener httpListener = (HttpListener)first.get();
            if (httpListener.getPaths() != null && !httpListener.getPaths().isEmpty()) {
                io.gravitee.definition.model.v4.listener.http.Path path = (io.gravitee.definition.model.v4.listener.http.Path)httpListener.getPaths().get(0);
                io.gravitee.definition.model.v4.listener.http.Path filteredPath = new io.gravitee.definition.model.v4.listener.http.Path(path.getPath());
                httpListener.setPaths(List.of(filteredPath));
            }
            httpListener.setPathMappings(null);
        }
        apiEntity.setProperties(null);
        apiEntity.setServices(null);
        apiEntity.setResources(null);
        apiEntity.setResponseTemplates(null);
    }

    @POST
    @Operation(summary="\ud83e\uddea Manage the API's lifecycle", description="\u26a0\ufe0f This resource is in alpha version. This implies that it is likely to be modified or even removed in future versions. \u26a0\ufe0f. <br><br>User must have the MANAGE_LIFECYCLE permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="204"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DEFINITION, acls={RolePermissionAction.UPDATE})})
    public Response doApiLifecycleAction(@Context HttpHeaders headers, @Parameter(required=true) @QueryParam(value="action") LifecycleAction action) {
        Response responseApi = this.getApi();
        Response.ResponseBuilder builder = this.evaluateIfMatch(headers, responseApi.getEntityTag().getValue());
        if (builder != null) {
            return builder.build();
        }
        if (action == null) {
            throw new BadRequestException("Valid LifecycleAction is required");
        }
        ApiEntity apiEntity = (ApiEntity)responseApi.getEntity();
        ApiEntity updatedApi = null;
        if (action == LifecycleAction.START) {
            this.checkApiLifeCycle(apiEntity, action);
            updatedApi = this.apiStateService.start(GraviteeContext.getExecutionContext(), apiEntity.getId(), this.getAuthenticatedUser());
        } else if (action == LifecycleAction.STOP) {
            this.checkApiLifeCycle(apiEntity, action);
            updatedApi = this.apiStateService.stop(GraviteeContext.getExecutionContext(), apiEntity.getId(), this.getAuthenticatedUser());
        }
        return Response.noContent().tag(Long.toString(updatedApi.getUpdatedAt().getTime())).lastModified(updatedApi.getUpdatedAt()).build();
    }

    private void checkApiLifeCycle(ApiEntity api, LifecycleAction action) {
        if (ApiLifecycleState.ARCHIVED.equals((Object)api.getLifecycleState())) {
            throw new BadRequestException("Deleted API can not be " + action.name().toLowerCase());
        }
        switch (api.getState()) {
            case STARTED: {
                if (!LifecycleAction.START.equals((Object)action)) break;
                throw new BadRequestException("API is already started");
            }
            case STOPPED: {
                if (LifecycleAction.STOP.equals((Object)action)) {
                    throw new BadRequestException("API is already stopped");
                }
                boolean apiReviewEnabled = this.parameterService.findAsBoolean(GraviteeContext.getExecutionContext(), Key.API_REVIEW_ENABLED, ParameterReferenceType.ENVIRONMENT);
                if (!apiReviewEnabled || api.getWorkflowState() == null || WorkflowState.REVIEW_OK.equals((Object)api.getWorkflowState())) break;
                throw new BadRequestException("API can not be started without being reviewed");
            }
        }
    }

    @Path(value="events")
    public ApiEventsResource getApiEventsResource() {
        return (ApiEventsResource)this.resourceContext.getResource(ApiEventsResource.class);
    }

    @Path(value="groups")
    public ApiGroupsResource getApiGroupsResource() {
        return (ApiGroupsResource)this.resourceContext.getResource(ApiGroupsResource.class);
    }

    @Path(value="members")
    public ApiMembersResource getApiMembersResource() {
        return (ApiMembersResource)this.resourceContext.getResource(ApiMembersResource.class);
    }

    @Path(value="metadata")
    public ApiMetadataResource getApiMetadataResource() {
        return (ApiMetadataResource)this.resourceContext.getResource(ApiMetadataResource.class);
    }

    @Path(value="pages")
    public ApiPagesResource getApiPagesResource() {
        return (ApiPagesResource)this.resourceContext.getResource(ApiPagesResource.class);
    }

    @Path(value="plans")
    public ApiPlansResource getApiPlansResource() {
        return (ApiPlansResource)this.resourceContext.getResource(ApiPlansResource.class);
    }

    @Path(value="subscriptions")
    public ApiSubscriptionsResource getApiSubscriptionsResource() {
        return (ApiSubscriptionsResource)this.resourceContext.getResource(ApiSubscriptionsResource.class);
    }

    @Path(value="subscribers")
    public ApiSubscribersResource geApiSubscribersResource() {
        return (ApiSubscribersResource)this.resourceContext.getResource(ApiSubscribersResource.class);
    }

    @Path(value="ratings")
    public ApiRatingResource getRatingResource() {
        return (ApiRatingResource)this.resourceContext.getResource(ApiRatingResource.class);
    }
}

