/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.exception.InvalidImageException;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.MediaEntity;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.security.utils.ImageUtils;
import io.gravitee.rest.api.service.MediaService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.UploadUnauthorized;
import io.swagger.annotations.ApiParam;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Tag(name="API Media")
public class ApiMediaResource
extends AbstractResource {
    @Inject
    private MediaService mediaService;
    @PathParam(value="api")
    @Parameter(name="api", required=true, description="The ID of the API")
    private String api;

    @POST
    @Operation(summary="Create a media for an API", description="User must have the API_DOCUMENTATION[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Media successfully created", content={@Content(mediaType="text/plain", schema=@Schema(implementation=PageEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DOCUMENTATION, acls={RolePermissionAction.CREATE})})
    @Path(value="/upload")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/plain"})
    public Response uploadApiMediaImage(@FormDataParam(value="file") InputStream uploadedInputStream, @FormDataParam(value="file") FormDataContentDisposition fileDetail, @FormDataParam(value="file") FormDataBodyPart body) throws IOException {
        if (fileDetail.getSize() > this.mediaService.getMediaMaxSize(GraviteeContext.getExecutionContext())) {
            throw new UploadUnauthorized("Max size achieved " + fileDetail.getSize());
        }
        MediaEntity mediaEntity = new MediaEntity();
        mediaEntity.setSize(fileDetail.getSize());
        mediaEntity.setType(body.getMediaType().getType());
        mediaEntity.setSubType(body.getMediaType().getSubtype());
        mediaEntity.setData(IOUtils.toByteArray((InputStream)uploadedInputStream));
        mediaEntity.setFileName(fileDetail.getFileName());
        try {
            ImageUtils.verify((String)body.getMediaType().getType(), (String)body.getMediaType().getSubtype(), (byte[])mediaEntity.getData());
        }
        catch (InvalidImageException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid image format").build();
        }
        String mediaId = this.mediaService.saveApiMedia(this.api, mediaEntity);
        return Response.status((int)200).entity((Object)mediaId).build();
    }

    @GET
    @Path(value="/{hash}")
    @Operation(summary="Retrieve a media for an API")
    public Response getApiMediaImage(@Context Request request, @PathParam(value="hash") String hash) {
        MediaEntity mediaEntity = this.mediaService.findByHashAndApiId(hash, this.api);
        if (mediaEntity == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        CacheControl cc = new CacheControl();
        cc.setNoTransform(true);
        cc.setMustRevalidate(false);
        cc.setNoCache(false);
        cc.setMaxAge(86400);
        EntityTag etag = new EntityTag(hash);
        Response.ResponseBuilder builder = request.evaluatePreconditions(etag);
        if (builder != null) {
            return builder.cacheControl(cc).build();
        }
        return Response.ok((Object)mediaEntity.getData()).type(mediaEntity.getMimeType()).cacheControl(cc).tag(etag).build();
    }

    @DELETE
    @Path(value="/{hash}")
    @Operation(summary="Delete media matching hash and API id", description="User must have the API_DOCUMENTATION[UPDATE] permission to use this endpoint")
    @Permissions(value={@Permission(value=RolePermission.API_DOCUMENTATION, acls={RolePermissionAction.UPDATE})})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Media successfully deleted"), @ApiResponse(responseCode="404", description="Media not found"), @ApiResponse(responseCode="403", description="Unauthorized user"), @ApiResponse(responseCode="500", description="Unexpected error")})
    public Response deleteApiMedia(@Context Request request, @PathParam(value="hash") @ApiParam(name="hash", value="The MD5 sum of the media") String hash) {
        this.mediaService.deleteByHashAndApi(hash, this.api);
        return Response.noContent().build();
    }
}

