/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.v4.connector;

import io.gravitee.rest.api.model.platform.plugin.PlatformPluginEntity;
import io.gravitee.rest.api.model.v4.connector.ConnectorExpandPluginEntity;
import io.gravitee.rest.api.model.v4.connector.ConnectorPluginEntity;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractConnectorsResource {
    protected Collection<ConnectorExpandPluginEntity> expand(Set<ConnectorPluginEntity> connectorPluginEntities, List<String> expands) {
        Stream<ConnectorExpandPluginEntity> stream = connectorPluginEntities.stream().map(this::convert);
        if (expands != null && !expands.isEmpty()) {
            for (String expand : expands) {
                if ("schema".equals(expand)) {
                    stream = stream.peek(connectorListItem -> connectorListItem.setSchema(this.getSchema(connectorListItem.getId())));
                    continue;
                }
                if (!"icon".equals(expand)) continue;
                stream = stream.peek(connectorListItem -> connectorListItem.setIcon(this.getIcon(connectorListItem.getId())));
            }
        }
        return stream.sorted(Comparator.comparing(PlatformPluginEntity::getName)).collect(Collectors.toList());
    }

    private ConnectorExpandPluginEntity convert(ConnectorPluginEntity endpointPluginEntity) {
        ConnectorExpandPluginEntity connectorExpandPluginEntity = new ConnectorExpandPluginEntity();
        connectorExpandPluginEntity.setId(endpointPluginEntity.getId());
        connectorExpandPluginEntity.setName(endpointPluginEntity.getName());
        connectorExpandPluginEntity.setDescription(endpointPluginEntity.getDescription());
        connectorExpandPluginEntity.setVersion(endpointPluginEntity.getVersion());
        connectorExpandPluginEntity.setSupportedApiType(endpointPluginEntity.getSupportedApiType());
        connectorExpandPluginEntity.setSupportedModes(endpointPluginEntity.getSupportedModes());
        connectorExpandPluginEntity.setAvailableFeatures(endpointPluginEntity.getAvailableFeatures());
        return connectorExpandPluginEntity;
    }

    protected abstract String getSchema(String var1);

    protected abstract String getIcon(String var1);
}

