/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.v4.api;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.v4.api.ApiResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.v4.api.ApiEntity;
import io.gravitee.rest.api.model.v4.api.NewApiEntity;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tag(name="\ud83e\uddea V4 - APIs")
public class ApisResource
extends AbstractResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApisResource.class);
    @Context
    private ResourceContext resourceContext;

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Operation(summary="\ud83e\uddea Create an API", description="\u26a0\ufe0f This resource is in alpha version. This implies that it is likely to be modified or even removed in future versions. \u26a0\ufe0f. <br><br>User must have API_PUBLISHER or ADMIN role to create an API.")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="API successfully created", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.CREATE})})
    public Response createApi(@Parameter(name="api", required=true) @Valid @NotNull NewApiEntity newApiEntity) {
        ApiEntity newApi = this.apiServiceV4.create(GraviteeContext.getExecutionContext(), newApiEntity, this.getAuthenticatedUser());
        return Response.created((URI)this.getLocationHeader(newApi.getId())).entity((Object)newApi).build();
    }

    @Path(value="{api}")
    public ApiResource getApiResource() {
        return (ApiResource)this.resourceContext.getResource(ApiResource.class);
    }
}

