/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.model.OrganizationFlowConfiguration;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.service.OrganizationService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.configuration.flow.FlowService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Tag(name="Flows")
public class FlowsResource
extends AbstractResource {
    @Inject
    private FlowService flowService;
    @Inject
    private OrganizationService organizationService;
    @PathParam(value="orgId")
    @Parameter(name="orgId", hidden=true)
    private String orgId;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get the global flow configuration of the organization")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Platform flows configuration", content={@Content(mediaType="application/json", schema=@Schema(implementation=OrganizationFlowConfiguration.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response hasPolicies() {
        boolean hasPlatformPolicies = !this.organizationService.findById(this.orgId).getFlows().isEmpty();
        OrganizationFlowConfiguration flowConfiguration = new OrganizationFlowConfiguration();
        flowConfiguration.setHasPolicies(hasPlatformPolicies);
        return Response.ok((Object)flowConfiguration).build();
    }

    @GET
    @Path(value="configuration-schema")
    @Produces(value={"application/json"})
    public Response getConfigurationSchemaForm() {
        return Response.ok((Object)this.flowService.getConfigurationSchemaForm()).build();
    }

    @GET
    @Path(value="flow-schema")
    @Produces(value={"application/json"})
    public Response getPlatformFlowSchemaForm() {
        return Response.ok((Object)this.flowService.getPlatformFlowSchemaForm(GraviteeContext.getExecutionContext())).build();
    }
}

