/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.param.AbstractParam;
import io.gravitee.rest.api.model.common.Sortable;
import io.gravitee.rest.api.model.common.SortableImpl;
import java.util.Arrays;

public class ApplicationsOrderParam
extends AbstractParam<ApplicationsOrder> {
    public ApplicationsOrderParam(String param) {
        super(param);
    }

    @Override
    protected ApplicationsOrder parse(String param) {
        if (param != null) {
            return ApplicationsOrder.forValue(param.toLowerCase());
        }
        return null;
    }

    protected Sortable toSortable() {
        ApplicationsOrder order = (ApplicationsOrder)((Object)this.getValue());
        if (order != null) {
            return new SortableImpl(order.field, order.isAsc);
        }
        return null;
    }

    public static enum ApplicationsOrder {
        NAME("name", true),
        NAME_DESC("name", false),
        UPDATED_AT("updated_at", true),
        UPDATED_AT_DESC("updated_at", false);

        public final String field;
        public final boolean isAsc;

        public static ApplicationsOrder forValue(String order) {
            boolean isAsc = !order.startsWith("-");
            String field = order.replace("-", "");
            return Arrays.stream(ApplicationsOrder.values()).filter(o -> o.field.equalsIgnoreCase(field) && o.isAsc == isAsc).findFirst().orElse(null);
        }

        private ApplicationsOrder(String field, boolean isAsc) {
            this.field = field;
            this.isAsc = isAsc;
        }

        public String toString() {
            return this.isAsc ? this.field : "-" + this.field;
        }
    }
}

