/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.common.data.domain.Page;
import io.gravitee.rest.api.management.rest.model.Pageable;
import io.gravitee.rest.api.management.rest.model.Subscription;
import io.gravitee.rest.api.management.rest.model.wrapper.SubscriptionEntityPageResult;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.ApplicationSubscriptionResource;
import io.gravitee.rest.api.management.rest.resource.param.ListStringParam;
import io.gravitee.rest.api.management.rest.resource.param.ListSubscriptionStatusParam;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.NewSubscriptionEntity;
import io.gravitee.rest.api.model.SubscriptionEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.subscription.SubscriptionMetadataQuery;
import io.gravitee.rest.api.model.subscription.SubscriptionQuery;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.model.v4.plan.GenericPlanEntity;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.SubscriptionService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.v4.PlanSearchService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.Explode;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BeanParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Tag(name="Application Subscriptions")
public class ApplicationSubscriptionsResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private SubscriptionService subscriptionService;
    @Inject
    private PlanSearchService planSearchService;
    @Inject
    private ApiService apiService;
    @Inject
    private UserService userService;
    @PathParam(value="application")
    @Parameter(name="application", hidden=true)
    private String application;

    @POST
    @Produces(value={"application/json"})
    @Operation(summary="Subscribe to a plan", description="User must have the MANAGE_SUBSCRIPTIONS permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Subscription successfully created", content={@Content(mediaType="application/json", schema=@Schema(implementation=Subscription.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_SUBSCRIPTION, acls={RolePermissionAction.CREATE})})
    public Response createSubscriptionWithApplication(@Parameter(name="plan", required=true) @NotNull @QueryParam(value="plan") String plan, NewSubscriptionEntity newSubscriptionEntity) {
        ExecutionContext executionContext;
        GenericPlanEntity planEntity;
        if (newSubscriptionEntity == null) {
            newSubscriptionEntity = new NewSubscriptionEntity();
        }
        if ((planEntity = this.planSearchService.findById(executionContext = GraviteeContext.getExecutionContext(), plan)).isCommentRequired() && (newSubscriptionEntity.getRequest() == null || newSubscriptionEntity.getRequest().isEmpty())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Plan requires a consumer comment when subscribing").build();
        }
        newSubscriptionEntity.setApplication(this.application);
        newSubscriptionEntity.setPlan(plan);
        Subscription subscription = this.convert(executionContext, this.subscriptionService.create(executionContext, newSubscriptionEntity));
        return Response.created((URI)this.getRequestUriBuilder().path(subscription.getId()).replaceQueryParam("plan", null).build(new Object[0])).entity((Object)subscription).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List subscriptions for the application", description="User must have the READ_SUBSCRIPTION permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Paged result of application's subscriptions", content={@Content(mediaType="application/json", schema=@Schema(implementation=SubscriptionEntityPageResult.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_SUBSCRIPTION, acls={RolePermissionAction.READ})})
    public SubscriptionEntityPageResult getApplicationSubscriptions(@BeanParam SubscriptionParam subscriptionParam, @Valid @BeanParam Pageable pageable, @Parameter(description="Expansion of data to return in subscriptions", array=@ArraySchema(schema=@Schema(allowableValues={"keys", "security"}))) @QueryParam(value="expand") List<String> expand) {
        SubscriptionQuery subscriptionQuery = subscriptionParam.toQuery();
        subscriptionQuery.setApplication(this.application);
        boolean expandApiKeys = expand != null && expand.contains("keys");
        boolean expandPlanSecurity = expand != null && expand.contains("security");
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        Page subscriptions = this.subscriptionService.search(executionContext, subscriptionQuery, pageable.toPageable(), expandApiKeys, expandPlanSecurity);
        SubscriptionEntityPageResult result = new SubscriptionEntityPageResult((Page<SubscriptionEntity>)subscriptions, pageable.getSize());
        SubscriptionMetadataQuery subscriptionMetadataQuery = new SubscriptionMetadataQuery(executionContext.getOrganizationId(), executionContext.getEnvironmentId(), (Collection)subscriptions.getContent()).withApis(true).withApplications(true).withPlans(true);
        result.setMetadata(this.subscriptionService.getMetadata(executionContext, subscriptionMetadataQuery).toMap());
        return result;
    }

    @Path(value="{subscription}")
    public ApplicationSubscriptionResource getApplicationSubscriptionResource() {
        return (ApplicationSubscriptionResource)this.resourceContext.getResource(ApplicationSubscriptionResource.class);
    }

    private Subscription convert(ExecutionContext executionContext, SubscriptionEntity subscriptionEntity) {
        Subscription subscription = new Subscription();
        subscription.setId(subscriptionEntity.getId());
        subscription.setCreatedAt(subscriptionEntity.getCreatedAt());
        subscription.setUpdatedAt(subscriptionEntity.getUpdatedAt());
        subscription.setStartingAt(subscriptionEntity.getStartingAt());
        subscription.setEndingAt(subscriptionEntity.getEndingAt());
        subscription.setProcessedAt(subscriptionEntity.getProcessedAt());
        subscription.setProcessedBy(subscriptionEntity.getProcessedBy());
        subscription.setReason(subscriptionEntity.getReason());
        subscription.setRequest(subscriptionEntity.getRequest());
        subscription.setStatus(subscriptionEntity.getStatus());
        subscription.setSubscribedBy(new Subscription.User(subscriptionEntity.getSubscribedBy(), this.userService.findById(executionContext, subscriptionEntity.getSubscribedBy(), true).getDisplayName()));
        GenericPlanEntity plan = this.planSearchService.findById(executionContext, subscriptionEntity.getPlan());
        subscription.setPlan(new Subscription.Plan(plan.getId(), plan.getName()));
        subscription.getPlan().setSecurity(plan.getPlanSecurity().getType());
        GenericApiEntity genericApiEntity = this.apiSearchService.findGenericById(executionContext, subscriptionEntity.getApi());
        subscription.setApi(new Subscription.Api(genericApiEntity.getId(), genericApiEntity.getName(), genericApiEntity.getApiVersion(), new Subscription.User(genericApiEntity.getPrimaryOwner().getId(), genericApiEntity.getPrimaryOwner().getDisplayName())));
        subscription.setClosedAt(subscriptionEntity.getClosedAt());
        subscription.setPausedAt(subscriptionEntity.getPausedAt());
        return subscription;
    }

    private static class SubscriptionParam {
        @QueryParam(value="plan")
        @Parameter(description="plan", explode=Explode.FALSE, schema=@Schema(type="array"))
        private ListStringParam plans;
        @QueryParam(value="api")
        @Parameter(description="api", explode=Explode.FALSE, schema=@Schema(type="array"))
        private ListStringParam apis;
        @QueryParam(value="status")
        @DefaultValue(value="ACCEPTED")
        @Parameter(description="Comma separated list of Subscription status, default is ACCEPTED", explode=Explode.FALSE, schema=@Schema(type="array"))
        private ListSubscriptionStatusParam status;
        @QueryParam(value="api_key")
        private String apiKey;
        @QueryParam(value="security_types")
        private ListStringParam securityTypes;

        private SubscriptionParam() {
        }

        public ListStringParam getPlans() {
            return this.plans;
        }

        public void setPlans(ListStringParam plans) {
            this.plans = plans;
        }

        public ListStringParam getApis() {
            return this.apis;
        }

        public void setApis(ListStringParam apis) {
            this.apis = apis;
        }

        public ListSubscriptionStatusParam getStatus() {
            return this.status;
        }

        public void setStatus(ListSubscriptionStatusParam status) {
            this.status = status;
        }

        public String getApiKey() {
            return this.apiKey;
        }

        public void setApiKey(String apiKey) {
            this.apiKey = apiKey;
        }

        public ListStringParam getSecurityTypes() {
            return this.securityTypes;
        }

        public void setSecurityTypes(ListStringParam securityTypes) {
            this.securityTypes = securityTypes;
        }

        private SubscriptionQuery toQuery() {
            SubscriptionQuery query = new SubscriptionQuery();
            query.setApis((Collection)this.apis);
            query.setPlans((Collection)this.plans);
            query.setStatuses((Collection)this.status);
            query.setApiKey(this.apiKey);
            query.setPlanSecurityTypes((Collection)this.securityTypes);
            return query;
        }
    }
}

