/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.model.Subscription;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.ApplicationSubscriptionApiKeysResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.SubscriptionConsumerStatus;
import io.gravitee.rest.api.model.SubscriptionEntity;
import io.gravitee.rest.api.model.UpdateSubscriptionConfigurationEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.model.v4.plan.GenericPlanEntity;
import io.gravitee.rest.api.service.SubscriptionService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.v4.PlanSearchService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Tag(name="Application Subscriptions")
public class ApplicationSubscriptionResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private SubscriptionService subscriptionService;
    @Inject
    private PlanSearchService planSearchService;
    @Inject
    private UserService userService;
    @PathParam(value="application")
    @Parameter(name="application", hidden=true)
    private String application;
    @PathParam(value="subscription")
    @Parameter(name="subscription")
    private String subscription;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get subscription information", description="User must have the READ permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Subscription information", content={@Content(mediaType="application/json", schema=@Schema(implementation=Subscription.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_SUBSCRIPTION, acls={RolePermissionAction.READ})})
    public Subscription getApplicationSubscription() {
        return this.convert(GraviteeContext.getExecutionContext(), this.subscriptionService.findById(this.subscription));
    }

    @DELETE
    @Produces(value={"application/json"})
    @Operation(summary="Close the subscription", description="User must have the APPLICATION_SUBSCRIPTION[DELETE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Subscription has been closed successfully", content={@Content(mediaType="application/json", schema=@Schema(implementation=Subscription.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_SUBSCRIPTION, acls={RolePermissionAction.DELETE})})
    public Response closeApplicationSubscription() {
        SubscriptionEntity subscriptionEntity = this.subscriptionService.findById(this.subscription);
        if (subscriptionEntity.getApplication().equals(this.application)) {
            ExecutionContext executionContext = GraviteeContext.getExecutionContext();
            return Response.ok((Object)this.convert(executionContext, this.subscriptionService.close(executionContext, this.subscription))).build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    @Path(value="apikeys")
    public ApplicationSubscriptionApiKeysResource getApiSubscriptionApiKeysResourceResource() {
        return (ApplicationSubscriptionApiKeysResource)this.resourceContext.getResource(ApplicationSubscriptionApiKeysResource.class);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a subscription configuration", description="User must have the APPLICATION_SUBSCRIPTION[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Update a subscription configuration", content={@Content(mediaType="application/json", schema=@Schema(implementation=SubscriptionEntity.class))}), @ApiResponse(responseCode="404", description="Subscription not found"), @ApiResponse(responseCode="400", description="Subscription not updatable, or bad subscription configuration format"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_SUBSCRIPTION, acls={RolePermissionAction.UPDATE})})
    public Response updateApplicationSubscription(@Valid @NotNull UpdateSubscriptionConfigurationEntity updateSubscriptionConfigurationEntity) {
        updateSubscriptionConfigurationEntity.setSubscriptionId(this.subscription);
        SubscriptionEntity updatedSubscription = this.subscriptionService.update(GraviteeContext.getExecutionContext(), updateSubscriptionConfigurationEntity);
        return Response.ok((Object)updatedSubscription).build();
    }

    @POST
    @Path(value="/_changeConsumerStatus")
    @Produces(value={"application/json"})
    @Operation(summary="Change the status of a subscription", description="User must have the APPLICATION_SUBSCRIPTION[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Subscription status successfully updated", content={@Content(mediaType="application/json", schema=@Schema(implementation=Subscription.class))}), @ApiResponse(responseCode="400", description="Status changes not authorized"), @ApiResponse(responseCode="404", description="API subscription does not exist"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_SUBSCRIPTION, acls={RolePermissionAction.UPDATE})})
    public Response changeSubscriptionConsumerStatus(@Parameter(required=true, schema=@Schema(allowableValues={"STARTED", "STOPPED"})) @QueryParam(value="status") SubscriptionConsumerStatus subscriptionConsumerStatus) {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        if (subscriptionConsumerStatus == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        switch (subscriptionConsumerStatus) {
            case STARTED: {
                SubscriptionEntity updatedSubscriptionEntity = this.subscriptionService.resumeConsumer(executionContext, this.subscription);
                return Response.ok((Object)this.convert(executionContext, updatedSubscriptionEntity)).build();
            }
            case STOPPED: {
                SubscriptionEntity updatedSubscriptionEntity = this.subscriptionService.pauseConsumer(executionContext, this.subscription);
                return Response.ok((Object)this.convert(executionContext, updatedSubscriptionEntity)).build();
            }
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    private Subscription convert(ExecutionContext executionContext, SubscriptionEntity subscriptionEntity) {
        Subscription subscription = new Subscription();
        subscription.setId(subscriptionEntity.getId());
        subscription.setCreatedAt(subscriptionEntity.getCreatedAt());
        subscription.setUpdatedAt(subscriptionEntity.getUpdatedAt());
        subscription.setStartingAt(subscriptionEntity.getStartingAt());
        subscription.setEndingAt(subscriptionEntity.getEndingAt());
        subscription.setProcessedAt(subscriptionEntity.getProcessedAt());
        subscription.setProcessedBy(subscriptionEntity.getProcessedBy());
        subscription.setReason(subscriptionEntity.getReason());
        subscription.setRequest(subscriptionEntity.getRequest());
        subscription.setStatus(subscriptionEntity.getStatus());
        subscription.setConsumerStatus(subscriptionEntity.getConsumerStatus());
        subscription.setSubscribedBy(new Subscription.User(subscriptionEntity.getSubscribedBy(), this.userService.findById(executionContext, subscriptionEntity.getSubscribedBy(), true).getDisplayName()));
        GenericPlanEntity plan = this.planSearchService.findById(executionContext, subscriptionEntity.getPlan());
        subscription.setPlan(new Subscription.Plan(plan.getId(), plan.getName()));
        if (plan.getPlanSecurity() != null) {
            subscription.getPlan().setSecurity(plan.getPlanSecurity().getType());
        }
        GenericApiEntity genericApiEntity = this.apiSearchService.findGenericById(executionContext, subscriptionEntity.getApi());
        subscription.setApi(new Subscription.Api(genericApiEntity.getId(), genericApiEntity.getName(), genericApiEntity.getApiVersion(), new Subscription.User(genericApiEntity.getPrimaryOwner().getId(), genericApiEntity.getPrimaryOwner().getDisplayName())));
        subscription.setClosedAt(subscriptionEntity.getClosedAt());
        subscription.setPausedAt(subscriptionEntity.getPausedAt());
        subscription.setConsumerPausedAt(subscriptionEntity.getConsumerPausedAt());
        return subscription;
    }
}

