/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.ApplicationEntity;
import io.gravitee.rest.api.model.SubscriptionEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.subscription.SubscriptionQuery;
import io.gravitee.rest.api.service.SubscriptionService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;

@Tag(name="Application Subscriptions")
public class ApplicationSubscribedResource
extends AbstractResource {
    @Inject
    private SubscriptionService subscriptionService;
    @Context
    private ResourceContext resourceContext;
    @PathParam(value="application")
    @Parameter(name="application", hidden=true)
    private String application;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List APIs subscribed by the application", description="User must have the APPLICATION_SUBSCRIPTION permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Paged result of subscribed APIs", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ApplicationEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_SUBSCRIPTION, acls={RolePermissionAction.READ})})
    public Collection<SubscribedApi> getApiSubscribed() {
        SubscriptionQuery subscriptionQuery = new SubscriptionQuery();
        subscriptionQuery.setApplication(this.application);
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        Collection subscriptions = this.subscriptionService.search(executionContext, subscriptionQuery);
        return subscriptions.stream().map(SubscriptionEntity::getApi).distinct().map(api -> this.apiSearchService.findGenericById(executionContext, api)).map(apiEntity -> new SubscribedApi(apiEntity.getId(), apiEntity.getName())).sorted((o1, o2) -> String.CASE_INSENSITIVE_ORDER.compare(o1.getName(), o2.getName())).collect(Collectors.toList());
    }

    private static class SubscribedApi {
        private final String id;
        private final String name;

        SubscribedApi(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }
    }
}

