/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractApiKeyResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.ApiKeyEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.ApiKeyService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Tag(name="API Keys")
public class ApplicationApiKeyResource
extends AbstractApiKeyResource {
    @Inject
    private ApiKeyService apiKeyService;
    @PathParam(value="application")
    @Parameter(name="application", hidden=true)
    private String application;

    @DELETE
    @Produces(value={"application/json"})
    @Operation(summary="Revoke an API key", description="User must have the MANAGE_API_KEYS permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="API key successfully revoked"), @ApiResponse(responseCode="400", description="API Key does not correspond to the application"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_SUBSCRIPTION, acls={RolePermissionAction.DELETE})})
    public Response revokeApiKeyForApplication(@PathParam(value="apikey") String apikey) {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        ApiKeyEntity apiKeyEntity = this.apiKeyService.findById(executionContext, apikey);
        if (apiKeyEntity.getApplication() == null || !apiKeyEntity.getApplication().getId().equals(this.application)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'key' parameter does not correspond to the application").build();
        }
        this.checkApplicationUsesSharedApiKey(apiKeyEntity.getApplication());
        this.apiKeyService.revoke(executionContext, apiKeyEntity, true);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }
}

