/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.common.data.domain.Page;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.NewRatingAnswerEntity;
import io.gravitee.rest.api.model.NewRatingEntity;
import io.gravitee.rest.api.model.RatingEntity;
import io.gravitee.rest.api.model.RatingSummaryEntity;
import io.gravitee.rest.api.model.UpdateRatingEntity;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.common.PageableImpl;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.service.RatingService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.UnauthorizedAccessException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Tag(name="API Ratings")
public class ApiRatingResource
extends AbstractResource {
    @Inject
    private RatingService ratingService;
    @PathParam(value="api")
    @Parameter(name="api", hidden=true)
    private String api;

    @GET
    @Operation(summary="List ratings for an API")
    @Produces(value={"application/json"})
    public Page<RatingEntity> getApiRating(@Min(value=1L) @QueryParam(value="pageNumber") @Min(value=1L) int pageNumber, @QueryParam(value="pageSize") int pageSize) {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        GenericApiEntity genericApiEntity = this.apiSearchService.findGenericById(executionContext, this.api);
        if (Visibility.PUBLIC.equals((Object)genericApiEntity.getVisibility()) || this.hasPermission(executionContext, RolePermission.API_RATING, this.api, RolePermissionAction.READ)) {
            Page ratingEntityPage = this.ratingService.findByApi(executionContext, this.api, (Pageable)new PageableImpl(pageNumber, pageSize));
            List filteredRatings = ratingEntityPage.getContent().stream().map(ratingEntity -> this.filterPermission(executionContext, this.api, (RatingEntity)ratingEntity)).collect(Collectors.toList());
            return new Page(filteredRatings, ratingEntityPage.getPageNumber(), (int)ratingEntityPage.getPageElements(), ratingEntityPage.getTotalElements());
        }
        throw new UnauthorizedAccessException();
    }

    @Path(value="current")
    @GET
    @Operation(summary="Retrieve current rating for an API provided by the authenticated user")
    @Produces(value={"application/json"})
    public RatingEntity getApiRatingByApiAndUser() {
        if (!this.isAuthenticated()) {
            return null;
        }
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        GenericApiEntity genericApiEntity = this.apiSearchService.findGenericById(executionContext, this.api);
        if (Visibility.PUBLIC.equals((Object)genericApiEntity.getVisibility()) || this.hasPermission(executionContext, RolePermission.API_RATING, this.api, RolePermissionAction.READ)) {
            return this.filterPermission(executionContext, this.api, this.ratingService.findByApiForConnectedUser(executionContext, this.api));
        }
        throw new UnauthorizedAccessException();
    }

    @Path(value="summary")
    @Operation(summary="Get the rating summary for an API")
    @GET
    @Produces(value={"application/json"})
    public RatingSummaryEntity getApiRatingSummaryByApi() {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        GenericApiEntity genericApiEntity = this.apiSearchService.findGenericById(executionContext, this.api);
        if (Visibility.PUBLIC.equals((Object)genericApiEntity.getVisibility()) || this.hasPermission(executionContext, RolePermission.API_RATING, this.api, RolePermissionAction.READ)) {
            return this.ratingService.findSummaryByApi(executionContext, this.api);
        }
        throw new UnauthorizedAccessException();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a new rating for an API", description="User must have the API_RATING[CREATE] permission to use this service")
    @Permissions(value={@Permission(value=RolePermission.API_RATING, acls={RolePermissionAction.CREATE})})
    public RatingEntity createApiRating(@Valid @NotNull NewRatingEntity rating) {
        rating.setApi(this.api);
        return this.filterPermission(GraviteeContext.getExecutionContext(), this.api, this.ratingService.create(GraviteeContext.getExecutionContext(), rating));
    }

    @Path(value="{rating}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update an existing rating for an API", description="User must have the API_RATING[UPDATE] permission to use this service")
    @Permissions(value={@Permission(value=RolePermission.API_RATING, acls={RolePermissionAction.UPDATE})})
    public RatingEntity updateApiRating(@PathParam(value="rating") String rating, @Valid @NotNull UpdateRatingEntity ratingEntity) {
        ratingEntity.setId(rating);
        ratingEntity.setApi(this.api);
        return this.filterPermission(GraviteeContext.getExecutionContext(), this.api, this.ratingService.update(GraviteeContext.getExecutionContext(), ratingEntity));
    }

    @Path(value="{rating}")
    @DELETE
    @Consumes(value={"application/json"})
    @Operation(summary="Delete an existing rating for an API", description="User must have the API_RATING[DELETE] permission to use this service")
    @Permissions(value={@Permission(value=RolePermission.API_RATING, acls={RolePermissionAction.DELETE})})
    public void deleteApiRating(@PathParam(value="rating") String rating) {
        this.ratingService.delete(GraviteeContext.getExecutionContext(), rating);
    }

    @Path(value="{rating}/answers")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create an answer to a rating for an API", description="User must have the API_RATING_ANSWER[CREATE] permission to use this service")
    @Permissions(value={@Permission(value=RolePermission.API_RATING_ANSWER, acls={RolePermissionAction.CREATE})})
    public RatingEntity createApiRatingAnswer(@PathParam(value="rating") String rating, @Valid @NotNull NewRatingAnswerEntity answer) {
        answer.setRatingId(rating);
        return this.filterPermission(GraviteeContext.getExecutionContext(), this.api, this.ratingService.createAnswer(GraviteeContext.getExecutionContext(), answer));
    }

    @Path(value="{rating}/answers/{answer}")
    @DELETE
    @Consumes(value={"application/json"})
    @Operation(summary="Delete an answer to a rating for an API", description="User must have the API_RATING_ANSWER[DELETE] permission to use this service")
    @Permissions(value={@Permission(value=RolePermission.API_RATING_ANSWER, acls={RolePermissionAction.DELETE})})
    public void deleteApiRatingAnswer(@PathParam(value="rating") String rating, @PathParam(value="answer") String answer) {
        this.ratingService.deleteAnswer(GraviteeContext.getExecutionContext(), rating, answer);
    }

    private RatingEntity filterPermission(ExecutionContext executionContext, String api, RatingEntity ratingEntity) {
        if (!this.hasPermission(executionContext, RolePermission.API_RATING_ANSWER, api, RolePermissionAction.READ) && ratingEntity != null) {
            ratingEntity.setAnswers(null);
        }
        return ratingEntity;
    }
}

