/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.organization;

import io.gravitee.common.data.domain.Page;
import io.gravitee.rest.api.management.rest.model.Pageable;
import io.gravitee.rest.api.management.rest.model.wrapper.UserPageResult;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.organization.UserResource;
import io.gravitee.rest.api.management.rest.resource.organization.UsersRegistrationResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.NewPreRegisterUserEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.validator.ValidNewPreRegisterUser;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Tag(name="Users")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class UsersResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private UserService userService;

    @GET
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_USERS, acls={RolePermissionAction.READ})})
    @Operation(summary="Search for users using the search engine", description="User must have the ORGANIZATION_USERS[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List users matching the query criteria", content={@Content(mediaType="application/json", schema=@Schema(implementation=UserPageResult.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public UserPageResult getAllUsers(@Parameter(name="q") @QueryParam(value="q") String query, @Valid @BeanParam Pageable pageable) {
        Page users = this.userService.search(GraviteeContext.getExecutionContext(), query, pageable.toPageable());
        return new UserPageResult((Page<UserEntity>)users, pageable.getSize());
    }

    @POST
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_USERS, acls={RolePermissionAction.CREATE})})
    @Operation(summary="Create a user", description="User must have the ORGANIZATION_USERS[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List users matching the query criteria", content={@Content(mediaType="application/json", schema=@Schema(implementation=UserEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response createUser(@ValidNewPreRegisterUser NewPreRegisterUserEntity newPreRegisterUserEntity) {
        UserEntity newUser = this.userService.create(GraviteeContext.getExecutionContext(), newPreRegisterUserEntity);
        if (newUser != null) {
            return Response.ok().entity((Object)newUser).build();
        }
        return Response.serverError().build();
    }

    @Path(value="{userId}")
    public UserResource getUserResource() {
        return (UserResource)this.resourceContext.getResource(UserResource.class);
    }

    @Path(value="registration")
    public UsersRegistrationResource getUsersRegistrationResource() {
        return (UsersRegistrationResource)this.resourceContext.getResource(UsersRegistrationResource.class);
    }
}

