/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.ThemeResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.theme.NewThemeEntity;
import io.gravitee.rest.api.model.theme.ThemeEntity;
import io.gravitee.rest.api.service.ThemeService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;

@Tag(name="Themes")
public class ThemesResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private ThemeService themeService;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_THEME, acls={RolePermissionAction.CREATE})})
    public ThemeEntity createTheme(@Valid @NotNull NewThemeEntity theme) {
        return this.themeService.create(GraviteeContext.getExecutionContext(), theme);
    }

    @Path(value="{themeId}")
    public ThemeResource getThemeResource() {
        return (ThemeResource)this.resourceContext.getResource(ThemeResource.class);
    }
}

