/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.param.Aggregation;
import io.gravitee.rest.api.management.rest.resource.param.AnalyticsParam;
import io.gravitee.rest.api.management.rest.resource.param.Range;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.analytics.Analytics;
import io.gravitee.rest.api.model.analytics.query.AggregationType;
import io.gravitee.rest.api.model.analytics.query.CountQuery;
import io.gravitee.rest.api.model.analytics.query.DateHistogramQuery;
import io.gravitee.rest.api.model.analytics.query.GroupByQuery;
import io.gravitee.rest.api.model.analytics.query.StatsQuery;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.AnalyticsService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.BeanParam;
import javax.ws.rs.GET;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Tag(name="Application Analytics")
public class ApplicationAnalyticsResource
extends AbstractResource {
    @Inject
    private AnalyticsService analyticsService;
    @PathParam(value="application")
    @Parameter(name="application", hidden=true)
    private String application;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get application analytics", description="User must have the APPLICATION_ANALYTICS[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Application analytics", content={@Content(mediaType="application/json", schema=@Schema(implementation=Analytics.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_ANALYTICS, acls={RolePermissionAction.READ})})
    public Response getApplicationAnalyticsHits(@BeanParam AnalyticsParam analyticsParam) {
        analyticsParam.validate();
        Analytics analytics = null;
        switch (analyticsParam.getType()) {
            case DATE_HISTO: {
                analytics = this.executeDateHisto(this.application, analyticsParam);
                break;
            }
            case GROUP_BY: {
                analytics = this.executeGroupBy(this.application, analyticsParam);
                break;
            }
            case COUNT: {
                analytics = this.executeCount(this.application, analyticsParam);
                break;
            }
            case STATS: {
                analytics = this.executeStats(this.application, analyticsParam);
            }
        }
        return Response.ok(analytics).build();
    }

    private Analytics executeStats(String application, AnalyticsParam analyticsParam) {
        StatsQuery query = new StatsQuery();
        query.setFrom(analyticsParam.getFrom());
        query.setTo(analyticsParam.getTo());
        query.setInterval(analyticsParam.getInterval());
        query.setQuery(analyticsParam.getQuery());
        query.setField(analyticsParam.getField());
        query.setRootField("application");
        query.setRootIdentifier(application);
        return this.analyticsService.execute(query);
    }

    private Analytics executeCount(String application, AnalyticsParam analyticsParam) {
        CountQuery query = new CountQuery();
        query.setFrom(analyticsParam.getFrom());
        query.setTo(analyticsParam.getTo());
        query.setInterval(analyticsParam.getInterval());
        query.setQuery(analyticsParam.getQuery());
        query.setRootField("application");
        query.setRootIdentifier(application);
        return this.analyticsService.execute(query);
    }

    private Analytics executeDateHisto(String application, AnalyticsParam analyticsParam) {
        DateHistogramQuery query = new DateHistogramQuery();
        query.setFrom(analyticsParam.getFrom());
        query.setTo(analyticsParam.getTo());
        query.setInterval(analyticsParam.getInterval());
        query.setQuery(analyticsParam.getQuery());
        query.setRootField("application");
        query.setRootIdentifier(application);
        List<Aggregation> aggregations = analyticsParam.getAggregations();
        if (aggregations != null) {
            List aggregationList = aggregations.stream().map(aggregation -> new io.gravitee.rest.api.model.analytics.query.Aggregation((Aggregation)aggregation){
                final /* synthetic */ Aggregation val$aggregation;
                {
                    this.val$aggregation = aggregation;
                }

                public AggregationType type() {
                    return AggregationType.valueOf((String)this.val$aggregation.getType().name().toUpperCase());
                }

                public String field() {
                    return this.val$aggregation.getField();
                }
            }).collect(Collectors.toList());
            query.setAggregations(aggregationList);
        }
        return this.analyticsService.execute(GraviteeContext.getExecutionContext(), query);
    }

    private Analytics executeGroupBy(String application, AnalyticsParam analyticsParam) {
        List<Range> ranges;
        GroupByQuery query = new GroupByQuery();
        query.setFrom(analyticsParam.getFrom());
        query.setTo(analyticsParam.getTo());
        query.setInterval(analyticsParam.getInterval());
        query.setQuery(analyticsParam.getQuery());
        query.setField(analyticsParam.getField());
        query.setRootField("application");
        query.setRootIdentifier(application);
        if (analyticsParam.getOrder() != null) {
            GroupByQuery.Order order = new GroupByQuery.Order();
            order.setField(analyticsParam.getOrder().getField());
            order.setType(analyticsParam.getOrder().getType());
            order.setOrder(analyticsParam.getOrder().isOrder());
            query.setOrder(order);
        }
        if ((ranges = analyticsParam.getRanges()) != null) {
            Map<Double, Double> rangeMap = ranges.stream().collect(Collectors.toMap(Range::getFrom, Range::getTo));
            query.setGroups(rangeMap);
        }
        return this.analyticsService.execute(GraviteeContext.getExecutionContext(), query);
    }
}

