/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.PolicyResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.PolicyDevelopmentEntity;
import io.gravitee.rest.api.model.PolicyEntity;
import io.gravitee.rest.api.model.PolicyListItem;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.PolicyService;
import io.gravitee.rest.api.service.impl.swagger.policy.PolicyOperationVisitorManager;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;

@Tag(name="Plugins")
public class PoliciesResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private PolicyService policyService;
    @Inject
    private PolicyOperationVisitorManager policyOperationVisitorManager;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List policies", description="User must have the MANAGEMENT_API[READ] permission to use this service")
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.READ})})
    public Collection<PolicyListItem> getPolicies(@QueryParam(value="expand") List<String> expand, @QueryParam(value="withResource") Boolean withResource) {
        Stream<PolicyListItem> stream = this.policyService.findAll(withResource).stream().map(this::convert);
        if (expand != null && !expand.isEmpty()) {
            Iterator<String> iterator = expand.iterator();
            while (iterator.hasNext()) {
                String s;
                switch (s = iterator.next()) {
                    case "schema": {
                        stream = stream.peek(policyListItem -> policyListItem.setSchema(this.policyService.getSchema(policyListItem.getId())));
                    }
                    case "icon": {
                        stream = stream.peek(policyListItem -> policyListItem.setIcon(this.policyService.getIcon(policyListItem.getId())));
                    }
                }
            }
        }
        return stream.sorted(Comparator.comparing(PolicyListItem::getName)).collect(Collectors.toList());
    }

    @Path(value="{policy}")
    public PolicyResource getPolicyResource() {
        return (PolicyResource)this.resourceContext.getResource(PolicyResource.class);
    }

    @GET
    @Path(value="swagger")
    @Produces(value={"application/json"})
    @Operation(summary="List policies which are handling Swagger / OAI definition", description="These policies are used when importing an OAI to create an API")
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.READ})})
    public List<PolicyListItem> getSwaggerPolicy() {
        return this.policyOperationVisitorManager.getPolicyVisitors().stream().filter(operationVisitor -> operationVisitor.display()).map(operationVisitor -> {
            PolicyListItem item = new PolicyListItem();
            item.setId(operationVisitor.getId());
            item.setName(operationVisitor.getName());
            return item;
        }).sorted(Comparator.comparing(PolicyListItem::getName)).collect(Collectors.toList());
    }

    private PolicyListItem convert(PolicyEntity policy) {
        PolicyListItem item = new PolicyListItem();
        item.setId(policy.getId());
        item.setName(policy.getName());
        item.setDescription(policy.getDescription());
        item.setVersion(policy.getVersion());
        item.setType(policy.getType());
        item.setCategory(policy.getCategory());
        PolicyDevelopmentEntity development = policy.getDevelopment();
        if (development != null) {
            item.setOnRequest(development.getOnRequestMethod() != null);
            item.setOnResponse(development.getOnResponseMethod() != null);
        } else {
            item.setOnRequest(true);
            item.setOnResponse(false);
        }
        return item;
    }
}

