/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.common.data.domain.MetadataPage;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.rest.api.management.rest.model.wrapper.AuditEntityMetadataPage;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.param.AuditParam;
import io.gravitee.rest.api.management.rest.resource.param.AuditType;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.audit.AuditEntity;
import io.gravitee.rest.api.model.audit.AuditQuery;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

@Tag(name="Audit")
public class AuditResource
extends AbstractResource {
    private static final List<Audit.AuditEvent> events = new ArrayList<Audit.AuditEvent>();
    @Context
    private ResourceContext resourceContext;
    @Inject
    private AuditService auditService;

    @GET
    @Operation(summary="Retrieve audit logs for the environment", description="User must have the ENVIRONMENT_AUDIT[READ] or ORGANIZATION_AUDIT[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of audits", content={@Content(mediaType="application/json", schema=@Schema(implementation=AuditEntityMetadataPage.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_AUDIT, acls={RolePermissionAction.READ}), @Permission(value=RolePermission.ORGANIZATION_AUDIT, acls={RolePermissionAction.READ})})
    public AuditEntityMetadataPage getAudits(@BeanParam AuditParam param) {
        AuditQuery query = new AuditQuery();
        query.setFrom(param.getFrom());
        query.setTo(param.getTo());
        query.setPage(param.getPage());
        query.setSize(param.getSize());
        if (param.getEnvironmentId() != null) {
            query.setEnvironmentIds(Collections.singletonList(param.getEnvironmentId()));
        }
        if (param.getApplicationId() != null) {
            query.setApplicationIds(Collections.singletonList(param.getApplicationId()));
        }
        if (param.getApiId() != null) {
            query.setApiIds(Collections.singletonList(param.getApiId()));
        }
        if (param.getType() != null) {
            query.setReferenceType(AuditType.fromAuditType(param.getType()));
        }
        if (param.getEvent() != null) {
            query.setEvents(Collections.singletonList(param.getEvent()));
        }
        return new AuditEntityMetadataPage((MetadataPage<AuditEntity>)this.auditService.search(GraviteeContext.getExecutionContext(), query));
    }

    @Path(value="/events")
    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List available audit event type for the environment", description="User must have the ENVIRONMENT_AUDIT[READ] or ORGANIZATION_AUDIT[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of audits", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=Audit.AuditEvent.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_AUDIT, acls={RolePermissionAction.READ}), @Permission(value=RolePermission.ORGANIZATION_AUDIT, acls={RolePermissionAction.READ})})
    public Response getAuditEvents() {
        if (events.isEmpty()) {
            Set subTypesOf = new Reflections("io.gravitee.repository.management.model", new Scanner[0]).getSubTypesOf(Audit.AuditEvent.class);
            for (Class clazz : subTypesOf) {
                if (!clazz.isEnum()) continue;
                events.addAll(Arrays.asList((Audit.AuditEvent[])clazz.getEnumConstants()));
            }
            events.sort(Comparator.comparing(Audit.AuditEvent::name));
        }
        return Response.ok(events).build();
    }
}

