/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.model.ApplicationEntity;
import io.gravitee.rest.api.service.ApplicationService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.ApplicationNotFoundException;
import io.gravitee.rest.api.service.exceptions.InvalidApplicationApiKeyModeException;
import javax.inject.Inject;

public class AbstractApiKeyResource
extends AbstractResource {
    @Inject
    private ApplicationService applicationService;

    protected void checkApplicationUsesSharedApiKey(ApplicationEntity applicationEntity) {
        this.checkApplicationUsesSharedApiKey(applicationEntity, true);
    }

    protected void checkApplicationDoesntUseSharedApiKey(ApplicationEntity applicationEntity) {
        this.checkApplicationUsesSharedApiKey(applicationEntity, false);
    }

    protected void checkApplicationDoesntUseSharedApiKey(ExecutionContext executionContext, String applicationId) {
        ApplicationEntity applicationEntity = this.applicationService.findById(executionContext, applicationId);
        if (applicationEntity == null) {
            throw new ApplicationNotFoundException(applicationId);
        }
        this.checkApplicationDoesntUseSharedApiKey(applicationEntity);
    }

    private void checkApplicationUsesSharedApiKey(ApplicationEntity applicationEntity, boolean usesSharedApiKey) {
        if (applicationEntity.hasApiKeySharedMode() != usesSharedApiKey) {
            throw new InvalidApplicationApiKeyModeException(String.format("Invalid operation for api key mode [%s] of application [%s]", applicationEntity.getApiKeyMode(), applicationEntity.getId()));
        }
    }
}

