/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.v4.entrypoint;

import io.gravitee.rest.api.management.rest.resource.v4.entrypoint.EntrypointResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.ConnectorListItem;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.platform.plugin.PlatformPluginEntity;
import io.gravitee.rest.api.model.v4.entrypoint.EntrypointExpandPluginEntity;
import io.gravitee.rest.api.model.v4.entrypoint.EntrypointPluginEntity;
import io.gravitee.rest.api.service.v4.EntrypointPluginService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;

@Tag(name="\ud83e\uddea V4 - Plugins")
public class EntrypointsResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private EntrypointPluginService entrypointService;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="\ud83e\uddea List entrypoint plugins", description="\u26a0\ufe0f This resource is in alpha version. This implies that it is likely to be modified or even removed in future versions. \u26a0\ufe0f. <br><br>User must have the ENVIRONMENT_API[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of entrypoints", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ConnectorListItem.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.READ})})
    public Collection<EntrypointExpandPluginEntity> getEntrypoint(@QueryParam(value="expand") List<String> expand) {
        Stream<EntrypointExpandPluginEntity> stream = this.entrypointService.findAll().stream().map(this::convert);
        if (expand != null && !expand.isEmpty()) {
            Iterator<String> iterator = expand.iterator();
            while (iterator.hasNext()) {
                String s;
                switch (s = iterator.next()) {
                    case "schema": {
                        stream = stream.peek(connectorListItem -> connectorListItem.setSchema(this.entrypointService.getSchema(connectorListItem.getId())));
                    }
                    case "icon": {
                        stream = stream.peek(connectorListItem -> connectorListItem.setIcon(this.entrypointService.getIcon(connectorListItem.getId())));
                    }
                }
            }
        }
        return stream.sorted(Comparator.comparing(PlatformPluginEntity::getName)).collect(Collectors.toList());
    }

    @Path(value="{entrypoint}")
    public EntrypointResource getEntrypointResource() {
        return (EntrypointResource)this.resourceContext.getResource(EntrypointResource.class);
    }

    private EntrypointExpandPluginEntity convert(EntrypointPluginEntity entrypointPluginEntity) {
        EntrypointExpandPluginEntity entrypointExpandEntity = new EntrypointExpandPluginEntity();
        entrypointExpandEntity.setId(entrypointPluginEntity.getId());
        entrypointExpandEntity.setName(entrypointPluginEntity.getName());
        entrypointExpandEntity.setDescription(entrypointPluginEntity.getDescription());
        entrypointExpandEntity.setVersion(entrypointPluginEntity.getVersion());
        entrypointExpandEntity.setSupportedApiType(entrypointPluginEntity.getSupportedApiType());
        entrypointExpandEntity.setSupportedModes(entrypointPluginEntity.getSupportedModes());
        return entrypointExpandEntity;
    }
}

