/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.PathParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Tag(name="Group Memberships")
public class GroupMemberResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private GroupService groupService;
    @PathParam(value="group")
    @Parameter(name="group", hidden=true)
    private String group;

    @DELETE
    @Operation(summary="Remove a group member")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Member has been removed successfully"), @ApiResponse(responseCode="400", description="User does not exist"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_GROUP, acls={RolePermissionAction.DELETE}), @Permission(value=RolePermission.GROUP_MEMBER, acls={RolePermissionAction.DELETE})})
    public Response deleteGroupMember(@PathParam(value="member") String userId) {
        this.groupService.deleteUserFromGroup(GraviteeContext.getExecutionContext(), this.group, userId);
        return Response.ok().build();
    }
}

