/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.EntrypointEntity;
import io.gravitee.rest.api.model.NewEntryPointEntity;
import io.gravitee.rest.api.model.UpdateEntryPointEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.EntrypointService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Tag(name="Entrypoints")
public class EntrypointsResource
extends AbstractResource {
    @Inject
    private EntrypointService entrypointService;

    @GET
    @Path(value="{entrypoint}")
    @Produces(value={"application/json"})
    @Operation(summary="Get a platform entrypoints", description="User must have the MANAGEMENT_ENTRYPOINT[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="A platform entrypoint", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntrypointEntity.class))}), @ApiResponse(responseCode="404", description="Entrypoint not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_ENTRYPOINT, acls={RolePermissionAction.READ}), @Permission(value=RolePermission.ORGANIZATION_ENTRYPOINT, acls={RolePermissionAction.READ})})
    public EntrypointEntity getEntrypoint(@PathParam(value="entrypoint") String entrypointId) {
        return this.entrypointService.findById(GraviteeContext.getExecutionContext(), entrypointId);
    }

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List the platform entrypoints", description="User must have the MANAGEMENT_ENTRYPOINT[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of platform entrypoints", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=EntrypointEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_ENTRYPOINT, acls={RolePermissionAction.READ}), @Permission(value=RolePermission.ORGANIZATION_ENTRYPOINT, acls={RolePermissionAction.READ})})
    public List<EntrypointEntity> getEntrypoints() {
        return this.entrypointService.findAll(GraviteeContext.getExecutionContext()).stream().sorted((o1, o2) -> String.CASE_INSENSITIVE_ORDER.compare(o1.getValue(), o2.getValue())).collect(Collectors.toList());
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a platform entrypoint", description="User must have the MANAGEMENT_ENTRYPOINT[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Entrypoint successfully created", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntrypointEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_ENTRYPOINT, acls={RolePermissionAction.CREATE}), @Permission(value=RolePermission.ORGANIZATION_ENTRYPOINT, acls={RolePermissionAction.CREATE})})
    public EntrypointEntity createEntrypoint(@Valid @NotNull NewEntryPointEntity entrypoint) {
        return this.entrypointService.create(GraviteeContext.getExecutionContext(), entrypoint);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a platform entrypoint", description="User must have the MANAGEMENT_ENTRYPOINT[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Updated entrypoint", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntrypointEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_ENTRYPOINT, acls={RolePermissionAction.UPDATE}), @Permission(value=RolePermission.ORGANIZATION_ENTRYPOINT, acls={RolePermissionAction.UPDATE})})
    public EntrypointEntity updateEntrypoint(@Valid @NotNull UpdateEntryPointEntity entrypoint) {
        return this.entrypointService.update(GraviteeContext.getExecutionContext(), entrypoint);
    }

    @Path(value="{entrypoint}")
    @DELETE
    @Consumes(value={"application/json"})
    @Operation(summary="Delete a platform entrypoint", description="User must have the MANAGEMENT_ENTRYPOINT[DELETE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Entrrypoint successfully deleted"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_ENTRYPOINT, acls={RolePermissionAction.DELETE}), @Permission(value=RolePermission.ORGANIZATION_ENTRYPOINT, acls={RolePermissionAction.DELETE})})
    public void deleteEntrypoint(@PathParam(value="entrypoint") String entrypoint) {
        this.entrypointService.delete(GraviteeContext.getExecutionContext(), entrypoint);
    }
}

