/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.organization;

import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.settings.ConsoleConfigEntity;
import io.gravitee.rest.api.model.settings.ConsoleSettingsEntity;
import io.gravitee.rest.api.service.ConfigService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Tag(name="Console")
public class ConsoleResource {
    @Inject
    private ConfigService configService;
    @Context
    private ResourceContext resourceContext;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get the console configuration needed for runtime", description="Every users can use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Console configuration", content={@Content(mediaType="application/json", schema=@Schema(implementation=ConsoleConfigEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public ConsoleConfigEntity getConsoleConfig() {
        return this.configService.getConsoleConfig(GraviteeContext.getExecutionContext());
    }

    @Deprecated
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Operation(summary="Save the console configuration")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Console configuration", content={@Content(mediaType="application/json", schema=@Schema(implementation=ConsoleSettingsEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_SETTINGS, acls={RolePermissionAction.CREATE, RolePermissionAction.UPDATE, RolePermissionAction.DELETE})})
    public Response saveConsoleConfig(@Parameter(name="config", required=true) @NotNull ConsoleSettingsEntity consoleSettingsEntity) {
        this.configService.save(GraviteeContext.getExecutionContext(), consoleSettingsEntity);
        return Response.ok().entity((Object)consoleSettingsEntity).build();
    }
}

