/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.NotifierEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.NotifierService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;

@Tag(name="Plugins")
public class NotifierResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private NotifierService notifierService;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get a notifier", description="User must have the MANAGEMENT_API[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Notifier plugin", content={@Content(mediaType="application/json", schema=@Schema(implementation=NotifierEntity.class))}), @ApiResponse(responseCode="404", description="Notifier not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.READ})})
    public NotifierEntity getNotifier(@PathParam(value="notifier") String notifier) {
        return this.notifierService.findById(notifier);
    }

    @GET
    @Path(value="schema")
    @Produces(value={"application/json"})
    @Operation(summary="Get a notifier's schema", description="User must have the MANAGEMENT_API[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Notifier's schema", content={@Content(mediaType="application/json", schema=@Schema(type="string"))}), @ApiResponse(responseCode="404", description="Notifier not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.READ})})
    public String getNotifierSchema(@PathParam(value="notifier") String notifier) {
        this.notifierService.findById(notifier);
        return this.notifierService.getSchema(notifier);
    }
}

