/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.MessageEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.MessageService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Tag(name="Messages")
public class MessagesResource
extends AbstractResource {
    @Inject
    private MessageService messageService;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Send a message to users depending on their profile", description="User must have the MANAGEMENT_MESSAGE[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Message successfully sent", content={@Content(mediaType="application/json", schema=@Schema(implementation=Integer.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_MESSAGE, acls={RolePermissionAction.CREATE})})
    public Response createMessage(MessageEntity message) {
        return Response.ok((Object)this.messageService.create(GraviteeContext.getExecutionContext(), message)).build();
    }
}

