/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.repository.management.model.NotificationReferenceType;
import io.gravitee.rest.api.exception.InvalidImageException;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.ApplicationAlertsResource;
import io.gravitee.rest.api.management.rest.resource.ApplicationAnalyticsResource;
import io.gravitee.rest.api.management.rest.resource.ApplicationApiKeysResource;
import io.gravitee.rest.api.management.rest.resource.ApplicationLogsResource;
import io.gravitee.rest.api.management.rest.resource.ApplicationMembersResource;
import io.gravitee.rest.api.management.rest.resource.ApplicationMetadataResource;
import io.gravitee.rest.api.management.rest.resource.ApplicationNotificationSettingsResource;
import io.gravitee.rest.api.management.rest.resource.ApplicationSubscribedResource;
import io.gravitee.rest.api.management.rest.resource.ApplicationSubscriptionsResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.ApplicationEntity;
import io.gravitee.rest.api.model.InlinePictureEntity;
import io.gravitee.rest.api.model.PictureEntity;
import io.gravitee.rest.api.model.UpdateApplicationEntity;
import io.gravitee.rest.api.model.UrlPictureEntity;
import io.gravitee.rest.api.model.configuration.application.ApplicationTypeEntity;
import io.gravitee.rest.api.model.notification.NotifierEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.security.utils.ImageUtils;
import io.gravitee.rest.api.service.ApplicationService;
import io.gravitee.rest.api.service.NotifierService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.configuration.application.ApplicationTypeService;
import io.gravitee.rest.api.service.exceptions.ApplicationNotFoundException;
import io.gravitee.rest.api.service.exceptions.ForbiddenAccessException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.ByteArrayOutputStream;
import java.net.URI;
import java.util.List;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;

@Tag(name="Applications")
public class ApplicationResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private ApplicationService applicationService;
    @Inject
    private NotifierService notifierService;
    @Inject
    private ApplicationTypeService applicationTypeService;
    @PathParam(value="application")
    @Parameter(name="application", required=true)
    private String application;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get an application", description="User must have the READ permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Application", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApplicationEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_DEFINITION, acls={RolePermissionAction.READ})})
    public ApplicationEntity getApplication() {
        return this.applicationService.findById(GraviteeContext.getExecutionContext(), this.application);
    }

    @GET
    @Path(value="configuration")
    @Produces(value={"application/json"})
    @Operation(summary="Get application type definition of an application", description="User must have the READ permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="ApplicationType", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApplicationTypeEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_DEFINITION, acls={RolePermissionAction.READ})})
    public Response getApplicationType() {
        ApplicationEntity applicationEntity = this.applicationService.findById(GraviteeContext.getExecutionContext(), this.application);
        ApplicationTypeEntity applicationType = this.applicationTypeService.getApplicationType(applicationEntity.getType());
        return Response.ok((Object)applicationType).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update an application", description="User must have APPLICATION_DEFINITION[UPDATE] permission to update an application.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Updated application", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApplicationEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_DEFINITION, acls={RolePermissionAction.UPDATE})})
    public ApplicationEntity updateApplication(@Valid @NotNull(message="An application must be provided") @Valid @NotNull(message="An application must be provided") UpdateApplicationEntity updatedApplication) {
        try {
            ImageUtils.verify((String)updatedApplication.getPicture());
            ImageUtils.verify((String)updatedApplication.getBackground());
        }
        catch (InvalidImageException e) {
            throw new BadRequestException("Invalid image format : " + e.getMessage());
        }
        return this.applicationService.update(GraviteeContext.getExecutionContext(), this.application, updatedApplication);
    }

    @GET
    @Path(value="picture")
    @Operation(summary="Get the application's picture", description="User must have the READ permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Application's picture", content={@Content(mediaType="*/*", schema=@Schema(type="string", format="binary"))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_DEFINITION, acls={RolePermissionAction.READ})})
    public Response getApplicationPicture(@Context Request request) throws ApplicationNotFoundException {
        return this.getImageResponse(request, (PictureEntity)this.applicationService.getPicture(GraviteeContext.getExecutionContext(), this.application));
    }

    @GET
    @Path(value="background")
    @Operation(summary="Get the application's background", description="User must have the READ permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Application's background", content={@Content(mediaType="*/*", schema=@Schema(type="string", format="binary"))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_DEFINITION, acls={RolePermissionAction.READ})})
    public Response getApplicationBackground(@Context Request request) throws ApplicationNotFoundException {
        return this.getImageResponse(request, (PictureEntity)this.applicationService.getBackground(GraviteeContext.getExecutionContext(), this.application));
    }

    private Response getImageResponse(Request request, PictureEntity picture) {
        if (picture instanceof UrlPictureEntity) {
            return Response.temporaryRedirect((URI)URI.create(((UrlPictureEntity)picture).getUrl())).build();
        }
        InlinePictureEntity image = (InlinePictureEntity)picture;
        if (image == null || image.getContent() == null) {
            return Response.ok().build();
        }
        CacheControl cc = new CacheControl();
        cc.setNoTransform(true);
        cc.setMustRevalidate(false);
        cc.setNoCache(false);
        cc.setMaxAge(86400);
        EntityTag etag = new EntityTag(Integer.toString(new String(image.getContent()).hashCode()));
        Response.ResponseBuilder builder = request.evaluatePreconditions(etag);
        if (builder != null) {
            return builder.cacheControl(cc).build();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(image.getContent(), 0, image.getContent().length);
        return Response.ok((Object)baos).cacheControl(cc).tag(etag).type(image.getType()).build();
    }

    @POST
    @Path(value="/renew_secret")
    @Produces(value={"application/json"})
    @Operation(summary="Renew the client secret for an OAuth2 application", description="User must have APPLICATION_DEFINITION[UPDATE] permission to update an application.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Updated application", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApplicationEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_DEFINITION, acls={RolePermissionAction.UPDATE})})
    public ApplicationEntity renewApplicationClientSecret() {
        return this.applicationService.renewClientSecret(GraviteeContext.getExecutionContext(), this.application);
    }

    @POST
    @Path(value="/_restore")
    @Produces(value={"application/json"})
    @Operation(summary="Restore the application", description="User must have ORGANIZATION:ADMIN role to restore an application.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Restored application", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApplicationEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public ApplicationEntity restoreApplication() {
        if (!this.isAdmin()) {
            throw new ForbiddenAccessException();
        }
        return this.applicationService.restore(GraviteeContext.getExecutionContext(), this.application);
    }

    @DELETE
    @Operation(summary="Delete an application", description="User must have the DELETE permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Application successfully deleted"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_DEFINITION, acls={RolePermissionAction.DELETE})})
    public Response deleteApplication() {
        this.applicationService.archive(GraviteeContext.getExecutionContext(), this.application);
        return Response.noContent().build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="notifiers")
    @Operation(summary="List available notifiers for application", description="User must have the APPLICATION_NOTIFICATION[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of notifiers", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=NotifierEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_NOTIFICATION, acls={RolePermissionAction.READ})})
    public List<NotifierEntity> getApplicationNotifiers() {
        return this.notifierService.list(NotificationReferenceType.APPLICATION, this.application);
    }

    @Path(value="members")
    public ApplicationMembersResource getApplicationMembersResource() {
        return (ApplicationMembersResource)this.resourceContext.getResource(ApplicationMembersResource.class);
    }

    @Path(value="subscriptions")
    public ApplicationSubscriptionsResource getApplicationSubscriptionsResource() {
        return (ApplicationSubscriptionsResource)this.resourceContext.getResource(ApplicationSubscriptionsResource.class);
    }

    @Path(value="subscribed")
    public ApplicationSubscribedResource getApplicationSubscribedResource() {
        return (ApplicationSubscribedResource)this.resourceContext.getResource(ApplicationSubscribedResource.class);
    }

    @Path(value="analytics")
    public ApplicationAnalyticsResource getApplicationAnalyticsResource() {
        return (ApplicationAnalyticsResource)this.resourceContext.getResource(ApplicationAnalyticsResource.class);
    }

    @Path(value="logs")
    public ApplicationLogsResource getApplicationLogsResource() {
        return (ApplicationLogsResource)this.resourceContext.getResource(ApplicationLogsResource.class);
    }

    @Path(value="notificationsettings")
    public ApplicationNotificationSettingsResource getNotificationSettingsResource() {
        return (ApplicationNotificationSettingsResource)this.resourceContext.getResource(ApplicationNotificationSettingsResource.class);
    }

    @Path(value="alerts")
    public ApplicationAlertsResource getApplicationAlertsResource() {
        return (ApplicationAlertsResource)this.resourceContext.getResource(ApplicationAlertsResource.class);
    }

    @Path(value="metadata")
    public ApplicationMetadataResource getApplicationMetadataResource() {
        return (ApplicationMetadataResource)this.resourceContext.getResource(ApplicationMetadataResource.class);
    }

    @Path(value="apikeys")
    public ApplicationApiKeysResource getApplicationApiKeysResource() {
        return (ApplicationApiKeysResource)this.resourceContext.getResource(ApplicationApiKeysResource.class);
    }
}

