/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.ApiMetadataEntity;
import io.gravitee.rest.api.model.NewApiMetadataEntity;
import io.gravitee.rest.api.model.UpdateApiMetadataEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.search.Indexable;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.service.ApiMetadataService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.search.SearchEngineService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import java.util.List;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Tag(name="API Metadata")
public class ApiMetadataResource
extends AbstractResource {
    @Inject
    private ApiMetadataService apiMetadataService;
    @Inject
    private SearchEngineService searchEngineService;
    @PathParam(value="api")
    @Parameter(name="api", hidden=true)
    private String api;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List metadata for the given API", description="User must have the API_METADATA[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of metadata", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ApiMetadataEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_METADATA, acls={RolePermissionAction.READ})})
    public List<ApiMetadataEntity> getApiMetadatas() {
        return this.apiMetadataService.findAllByApi(this.api);
    }

    @GET
    @Path(value="{metadata}")
    @Produces(value={"application/json"})
    @Operation(summary="A metadata for the given API and metadata id", description="User must have the API_METADATA[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="A metadata", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiMetadataEntity.class))}), @ApiResponse(responseCode="404", description="Metadata not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_METADATA, acls={RolePermissionAction.READ})})
    public ApiMetadataEntity getApiMetadata(@PathParam(value="metadata") String metadata) {
        return this.apiMetadataService.findByIdAndApi(metadata, this.api);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create an API metadata", description="User must have the API_METADATA[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="A new API metadata", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiMetadataEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_METADATA, acls={RolePermissionAction.CREATE})})
    public Response createApiMetadata(@Valid @NotNull NewApiMetadataEntity metadata) {
        metadata.setApiId(this.api);
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        ApiMetadataEntity apiMetadataEntity = this.apiMetadataService.create(executionContext, metadata);
        GenericApiEntity genericApiEntity = this.apiMetadataService.fetchMetadataForApi(executionContext, this.apiSearchService.findGenericById(executionContext, this.api));
        this.searchEngineService.index(executionContext, (Indexable)genericApiEntity, false);
        return Response.created((URI)this.getLocationHeader(apiMetadataEntity.getKey())).entity((Object)apiMetadataEntity).build();
    }

    @PUT
    @Path(value="{metadata}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update an API metadata", description="User must have the API_METADATA[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="API metadata", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiMetadataEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_METADATA, acls={RolePermissionAction.UPDATE})})
    public Response updateApiMetadata(@PathParam(value="metadata") String metadataPathParam, @Valid @NotNull UpdateApiMetadataEntity metadata) {
        metadata.setApiId(this.api);
        return Response.ok((Object)this.apiMetadataService.update(GraviteeContext.getExecutionContext(), metadata)).build();
    }

    @DELETE
    @Path(value="{metadata}")
    @Operation(summary="Delete a metadata", description="User must have the API_METADATA[DELETE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Metadata successfully deleted"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_METADATA, acls={RolePermissionAction.DELETE})})
    public Response deleteApiMetadata(@PathParam(value="metadata") String metadata) {
        this.apiMetadataService.delete(GraviteeContext.getExecutionContext(), metadata, this.api);
        GenericApiEntity genericApiEntity = this.apiMetadataService.fetchMetadataForApi(GraviteeContext.getExecutionContext(), this.apiSearchService.findGenericById(GraviteeContext.getExecutionContext(), this.api));
        this.searchEngineService.index(GraviteeContext.getExecutionContext(), (Indexable)genericApiEntity, false);
        return Response.noContent().build();
    }
}

