/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.model.wrapper.ApiGroupsWithMembersMap;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.v4.ApiGroupService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

public class ApiGroupsResource
extends AbstractResource {
    @Inject
    protected ApiGroupService apiGroupService;
    @PathParam(value="api")
    @Parameter(name="api", hidden=true)
    private String apiId;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get API groups mapped to members", description="User must have the MANAGE_MEMBERS permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="API groups with members", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiGroupsWithMembersMap.class))}), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="500", description="Internal Server Error")})
    @Permissions(value={@Permission(value=RolePermission.API_MEMBER, acls={RolePermissionAction.READ})})
    public ApiGroupsWithMembersMap getApiGroupsWithMembers() {
        return new ApiGroupsWithMembersMap(this.apiGroupService.getGroupsWithMembers(GraviteeContext.getExecutionContext(), this.apiId));
    }
}

