/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.api.DefinitionContextEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.ApiDefinitionContextService;
import io.swagger.v3.oas.annotations.Hidden;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;

public class ApiDefinitionContextResource {
    @PathParam(value="api")
    private String apiId;
    private final ApiDefinitionContextService definitionContextService;

    @Inject
    public ApiDefinitionContextResource(ApiDefinitionContextService definitionContextService) {
        this.definitionContextService = definitionContextService;
    }

    @PUT
    @Hidden
    @Consumes(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.API_DEFINITION, acls={RolePermissionAction.UPDATE})})
    public Response updateDefinitionContext(@Valid @NotNull DefinitionContextEntity definitionContext) {
        this.definitionContextService.setDefinitionContext(this.apiId, definitionContext);
        return Response.ok().build();
    }
}

