/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.provider;

import java.io.IOException;
import java.util.List;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.Provider;

@Provider
@PreMatching
public class UriBuilderRequestFilter
implements ContainerRequestFilter {
    public void filter(ContainerRequestContext ctx) throws IOException {
        List hosts;
        List schemes = (List)ctx.getHeaders().get((Object)"X-Forwarded-Proto");
        UriBuilder baseBuilder = ctx.getUriInfo().getBaseUriBuilder();
        UriBuilder requestBuilder = ctx.getUriInfo().getRequestUriBuilder();
        if (schemes != null && !schemes.isEmpty()) {
            String scheme = (String)schemes.get(0);
            baseBuilder.scheme(scheme);
            requestBuilder.scheme(scheme);
            ctx.setRequestUri(baseBuilder.build(new Object[0]), requestBuilder.build(new Object[0]));
        }
        if ((hosts = (List)ctx.getHeaders().get((Object)"X-Forwarded-Host")) != null && !hosts.isEmpty()) {
            String host = (String)hosts.get(0);
            if (host.contains(":")) {
                String[] parts = host.split(":");
                baseBuilder.host(parts[0]).port(Integer.parseInt(parts[1]));
                requestBuilder.host(parts[0]).port(Integer.parseInt(parts[1]));
            } else {
                baseBuilder.host(host);
                requestBuilder.host(host);
            }
            ctx.setRequestUri(baseBuilder.build(new Object[0]), requestBuilder.build(new Object[0]));
        }
    }
}

